"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UserPanelActions = exports.USER_PANEL_ACTIONS_CLASS = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _redirect_to_users = require("../../../../../../common/components/link_to/redirect_to_users");
var _types = require("../../../../../../app/types");
var _links = require("../../../../../../common/components/links");
var _translation = require("../translation");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const USER_PANEL_ACTIONS_CLASS = 'user-panel-actions-trigger';
exports.USER_PANEL_ACTIONS_CLASS = USER_PANEL_ACTIONS_CLASS;
const UserPanelActions = /*#__PURE__*/_react.default.memo(({
  className,
  openUserDetailsPanel,
  userName
}) => {
  const [isPopoverOpen, setPopover] = (0, _react.useState)(false);
  const {
    href
  } = (0, _links.useGetSecuritySolutionLinkProps)()({
    deepLinkId: _types.SecurityPageName.users,
    path: (0, _redirect_to_users.getUsersDetailsUrl)(userName)
  });
  const onButtonClick = (0, _react.useCallback)(() => {
    setPopover(!isPopoverOpen);
  }, [isPopoverOpen]);
  const closePopover = () => {
    setPopover(false);
  };
  const handleopenUserDetailsPanel = (0, _react.useCallback)(() => {
    openUserDetailsPanel(userName);
    closePopover();
  }, [userName, openUserDetailsPanel]);
  const items = (0, _react.useMemo)(() => [/*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
    icon: "expand",
    key: "userActionsViewUserSummary",
    onClick: handleopenUserDetailsPanel,
    "data-test-subj": "user-panel-actions-view-summary"
  }, _translation.VIEW_USER_SUMMARY), /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
    icon: "popout",
    key: "userActionsOpenUserDetailsPage",
    "data-test-subj": "user-panel-actions-open-user-details",
    onClick: closePopover,
    href: href,
    target: "_blank"
  }, _translation.OPEN_USER_DETAILS_PAGE)], [handleopenUserDetailsPanel, href]);
  const button = (0, _react.useMemo)(() => /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    "aria-label": _translation.SUMMARY_PANEL_ACTIONS,
    className: USER_PANEL_ACTIONS_CLASS,
    iconType: "boxesHorizontal",
    onClick: onButtonClick
  }), [onButtonClick]);
  return /*#__PURE__*/_react.default.createElement("div", {
    className: className
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    button: button,
    isOpen: isPopoverOpen,
    closePopover: closePopover,
    panelPaddingSize: "none",
    anchorPosition: "downLeft",
    panelClassName: "withHoverActions__popover"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuPanel, {
    "data-test-subj": "user-actions-panel",
    size: "s",
    items: items
  })));
});
exports.UserPanelActions = UserPanelActions;
UserPanelActions.displayName = 'UserPanelActions';