"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UserPanel = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _fp = require("lodash/fp");
var _risk_score = require("../../../../../../explore/containers/risk_score");
var _search_strategy = require("../../../../../../../common/search_strategy");
var _empty_value = require("../../../../../../common/components/empty_value");
var _common = require("../../../../../../explore/components/risk_score/severity/common");
var _first_last_seen = require("../../../../../../common/components/first_last_seen");
var _field_renderers = require("../../../../../../timelines/components/field_renderers/field_renderers");
var _links = require("../../../../../../common/components/links");
var _get_timeline_event_data = require("../../../utils/get_timeline_event_data");
var _translation = require("../translation");
var _wrappers = require("../wrappers");
var _user_panel_actions = require("./user_panel_actions");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const UserPanelSection = ({
  grow,
  title,
  children
}) => children ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: grow
}, title && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
  size: "xxs"
}, /*#__PURE__*/_react.default.createElement("h5", null, title)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
  size: "xs"
})), children) : null;
const UserPanel = /*#__PURE__*/_react.default.memo(({
  data,
  selectedPatterns,
  openUserDetailsPanel
}) => {
  const userName = (0, _react.useMemo)(() => (0, _get_timeline_event_data.getTimelineEventData)('user.name', data), [data]);
  const {
    data: userRisk,
    isLicenseValid: isRiskLicenseValid
  } = (0, _risk_score.useRiskScore)({
    riskEntity: _search_strategy.RiskScoreEntity.user,
    skip: userName == null
  });
  const renderUserActions = (0, _react.useCallback)(() => /*#__PURE__*/_react.default.createElement(_user_panel_actions.UserPanelActions, {
    openUserDetailsPanel: openUserDetailsPanel,
    userName: userName
  }), [openUserDetailsPanel, userName]);
  const [userRiskScore, userRiskLevel] = (0, _react.useMemo)(() => {
    const userRiskData = userRisk && userRisk.length > 0 ? userRisk[0] : undefined;
    const userRiskValue = userRiskData ? Math.round(userRiskData.user.risk.calculated_score_norm) : (0, _empty_value.getEmptyTagValue)();
    const userRiskSeverity = userRiskData ? /*#__PURE__*/_react.default.createElement(_common.RiskScore, {
      severity: userRiskData.user.risk.calculated_level,
      hideBackgroundColor: true
    }) : (0, _empty_value.getEmptyTagValue)();
    return [userRiskValue, userRiskSeverity];
  }, [userRisk]);
  const sourceIpFields = (0, _react.useMemo)(() => {
    var _find$values, _find;
    return (_find$values = (_find = (0, _fp.find)({
      field: 'source.ip',
      category: 'source'
    }, data)) === null || _find === void 0 ? void 0 : _find.values) !== null && _find$values !== void 0 ? _find$values : [];
  }, [data]);
  const renderSourceIp = (0, _react.useCallback)(ip => ip != null ? /*#__PURE__*/_react.default.createElement(_links.NetworkDetailsLink, {
    ip: ip
  }) : (0, _empty_value.getEmptyTagValue)(), []);
  return /*#__PURE__*/_react.default.createElement(_wrappers.SummaryPanel, {
    actionsClassName: _user_panel_actions.USER_PANEL_ACTIONS_CLASS,
    grow: true,
    renderActionsPopover: userName ? renderUserActions : undefined,
    title: _translation.USER_PANEL_TITLE
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    "data-test-subj": "user-panel"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 2
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(UserPanelSection, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "userAvatar",
    size: "xl"
  })), /*#__PURE__*/_react.default.createElement(UserPanelSection, {
    title: _translation.USER_NAME_TITLE
  }, userName ? /*#__PURE__*/_react.default.createElement(_links.UserDetailsLink, {
    userName: userName
  }) : (0, _empty_value.getEmptyTagValue)())), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), isRiskLicenseValid && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    "data-test-subj": "user-panel-risk"
  }, userRiskScore && /*#__PURE__*/_react.default.createElement(UserPanelSection, {
    title: _translation.USER_RISK_SCORE
  }, userRiskScore), userRiskLevel && /*#__PURE__*/_react.default.createElement(UserPanelSection, {
    title: _translation.USER_RISK_CLASSIFICATION
  }, userRiskLevel)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    "data-test-subj": "user-panel-ip"
  }, /*#__PURE__*/_react.default.createElement(UserPanelSection, {
    title: _translation.IP_ADDRESSES_TITLE,
    grow: 2
  }, /*#__PURE__*/_react.default.createElement(_field_renderers.DefaultFieldRenderer, {
    rowItems: sourceIpFields,
    attrName: 'source.ip',
    idPrefix: "alert-details-page-user",
    render: renderSourceIp
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(UserPanelSection, {
    title: _translation.LAST_SEEN_TITLE,
    grow: 2
  }, /*#__PURE__*/_react.default.createElement(_first_last_seen.FirstLastSeen, {
    indexPatterns: selectedPatterns,
    field: 'user.name',
    value: userName,
    type: _first_last_seen.FirstLastSeenType.LAST_SEEN
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null))));
});
exports.UserPanel = UserPanel;
UserPanel.displayName = 'UserPanel';