"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.VIEW_USER_SUMMARY = exports.VIEW_HOST_SUMMARY = exports.USER_RISK_SCORE = exports.USER_RISK_CLASSIFICATION = exports.USER_PANEL_TITLE = exports.USER_NAME_TITLE = exports.SUMMARY_PANEL_ACTIONS = exports.SEVERITY_TITLE = exports.RULE_PANEL_TITLE = exports.RULE_NAME_TITLE = exports.RULE_DESCRIPTION_TITLE = exports.RISK_SCORE_TITLE = exports.OPERATING_SYSTEM_TITLE = exports.OPEN_USER_DETAILS_PAGE = exports.OPEN_RULE_DETAILS_PAGE = exports.OPEN_HOST_DETAILS_PAGE = exports.NO_RELATED_CASES_FOUND = exports.LOADING_CASES = exports.LAST_SEEN_TITLE = exports.IP_ADDRESSES_TITLE = exports.HOST_RISK_SCORE = exports.HOST_RISK_CLASSIFICATION = exports.HOST_PANEL_TITLE = exports.HOST_NAME_TITLE = exports.ERROR_LOADING_CASES = exports.CASE_NO_READ_PERMISSIONS = exports.CASES_PANEL_TITLE = exports.CASES_PANEL_SUBTITLE = exports.CASES_PANEL_CASE_STATUS = exports.ALERT_REASON_PANEL_TITLE = exports.AGENT_STATUS_TITLE = exports.ADD_TO_NEW_CASE_BUTTON = exports.ADD_TO_EXISTING_CASE_BUTTON = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CASES_PANEL_TITLE = _i18n.i18n.translate('xpack.securitySolution.alerts.alertDetails.summary.cases.title', {
  defaultMessage: 'Cases'
});
exports.CASES_PANEL_TITLE = CASES_PANEL_TITLE;
const CASES_PANEL_SUBTITLE = caseCount => _i18n.i18n.translate('xpack.securitySolution.alerts.alertDetails.summary.cases.subTitle', {
  values: {
    caseCount
  },
  defaultMessage: 'Showing the {caseCount} most recently created cases containing this alert'
});
exports.CASES_PANEL_SUBTITLE = CASES_PANEL_SUBTITLE;
const CASES_PANEL_CASE_STATUS = _i18n.i18n.translate('xpack.securitySolution.alerts.alertDetails.summary.cases.status', {
  defaultMessage: 'Status'
});
exports.CASES_PANEL_CASE_STATUS = CASES_PANEL_CASE_STATUS;
const ALERT_REASON_PANEL_TITLE = _i18n.i18n.translate('xpack.securitySolution.alerts.alertDetails.summary.alertReason.title', {
  defaultMessage: 'Alert reason'
});
exports.ALERT_REASON_PANEL_TITLE = ALERT_REASON_PANEL_TITLE;
const RULE_PANEL_TITLE = _i18n.i18n.translate('xpack.securitySolution.alerts.alertDetails.summary.rule.title', {
  defaultMessage: 'Rule'
});
exports.RULE_PANEL_TITLE = RULE_PANEL_TITLE;
const HOST_PANEL_TITLE = _i18n.i18n.translate('xpack.securitySolution.alerts.alertDetails.summary.host.title', {
  defaultMessage: 'Host'
});
exports.HOST_PANEL_TITLE = HOST_PANEL_TITLE;
const USER_PANEL_TITLE = _i18n.i18n.translate('xpack.securitySolution.alerts.alertDetails.summary.user.title', {
  defaultMessage: 'User'
});
exports.USER_PANEL_TITLE = USER_PANEL_TITLE;
const RULE_NAME_TITLE = _i18n.i18n.translate('xpack.securitySolution.alerts.alertDetails.summary.rule.name', {
  defaultMessage: 'Rule name'
});
exports.RULE_NAME_TITLE = RULE_NAME_TITLE;
const RISK_SCORE_TITLE = _i18n.i18n.translate('xpack.securitySolution.alerts.alertDetails.summary.rule.riskScore', {
  defaultMessage: 'Risk score'
});
exports.RISK_SCORE_TITLE = RISK_SCORE_TITLE;
const SEVERITY_TITLE = _i18n.i18n.translate('xpack.securitySolution.alerts.alertDetails.summary.rule.severity', {
  defaultMessage: 'Severity'
});
exports.SEVERITY_TITLE = SEVERITY_TITLE;
const RULE_DESCRIPTION_TITLE = _i18n.i18n.translate('xpack.securitySolution.alerts.alertDetails.summary.rule.description', {
  defaultMessage: 'Rule description'
});
exports.RULE_DESCRIPTION_TITLE = RULE_DESCRIPTION_TITLE;
const OPEN_RULE_DETAILS_PAGE = _i18n.i18n.translate('xpack.securitySolution.alerts.alertDetails.summary.rule.action.openRuleDetailsPage', {
  defaultMessage: 'Open rule details page'
});
exports.OPEN_RULE_DETAILS_PAGE = OPEN_RULE_DETAILS_PAGE;
const NO_RELATED_CASES_FOUND = _i18n.i18n.translate('xpack.securitySolution.alerts.alertDetails.summary.case.noCasesFound', {
  defaultMessage: 'Related cases were not found for this alert'
});
exports.NO_RELATED_CASES_FOUND = NO_RELATED_CASES_FOUND;
const LOADING_CASES = _i18n.i18n.translate('xpack.securitySolution.alerts.alertDetails.summary.case.loading', {
  defaultMessage: 'Loading related cases...'
});
exports.LOADING_CASES = LOADING_CASES;
const ERROR_LOADING_CASES = _i18n.i18n.translate('xpack.securitySolution.alerts.alertDetails.summary.case.error', {
  defaultMessage: 'Error loading related cases'
});
exports.ERROR_LOADING_CASES = ERROR_LOADING_CASES;
const CASE_NO_READ_PERMISSIONS = _i18n.i18n.translate('xpack.securitySolution.alerts.alertDetails.summary.case.noRead', {
  defaultMessage: 'You do not have the required permissions to view related cases. If you need to view cases, contact your Kibana administrator'
});
exports.CASE_NO_READ_PERMISSIONS = CASE_NO_READ_PERMISSIONS;
const ADD_TO_EXISTING_CASE_BUTTON = _i18n.i18n.translate('xpack.securitySolution.alerts.alertDetails.summary.case.addToExistingCase', {
  defaultMessage: 'Add to existing case'
});
exports.ADD_TO_EXISTING_CASE_BUTTON = ADD_TO_EXISTING_CASE_BUTTON;
const ADD_TO_NEW_CASE_BUTTON = _i18n.i18n.translate('xpack.securitySolution.alerts.alertDetails.summary.case.addToNewCase', {
  defaultMessage: 'Add to new case'
});
exports.ADD_TO_NEW_CASE_BUTTON = ADD_TO_NEW_CASE_BUTTON;
const HOST_NAME_TITLE = _i18n.i18n.translate('xpack.securitySolution.alerts.alertDetails.summary.host.hostName.title', {
  defaultMessage: 'Host name'
});
exports.HOST_NAME_TITLE = HOST_NAME_TITLE;
const OPERATING_SYSTEM_TITLE = _i18n.i18n.translate('xpack.securitySolution.alerts.alertDetails.summary.host.osName.title', {
  defaultMessage: 'Operating system'
});
exports.OPERATING_SYSTEM_TITLE = OPERATING_SYSTEM_TITLE;
const AGENT_STATUS_TITLE = _i18n.i18n.translate('xpack.securitySolution.alerts.alertDetails.summary.host.agentStatus.title', {
  defaultMessage: 'Agent status'
});
exports.AGENT_STATUS_TITLE = AGENT_STATUS_TITLE;
const IP_ADDRESSES_TITLE = _i18n.i18n.translate('xpack.securitySolution.alerts.alertDetails.summary.ipAddresses.title', {
  defaultMessage: 'IP addresses'
});
exports.IP_ADDRESSES_TITLE = IP_ADDRESSES_TITLE;
const LAST_SEEN_TITLE = _i18n.i18n.translate('xpack.securitySolution.alerts.alertDetails.summary.lastSeen.title', {
  defaultMessage: 'Last seen'
});
exports.LAST_SEEN_TITLE = LAST_SEEN_TITLE;
const VIEW_HOST_SUMMARY = _i18n.i18n.translate('xpack.securitySolution.alerts.alertDetails.summary.host.action.viewHostSummary', {
  defaultMessage: 'View host summary'
});
exports.VIEW_HOST_SUMMARY = VIEW_HOST_SUMMARY;
const OPEN_HOST_DETAILS_PAGE = _i18n.i18n.translate('xpack.securitySolution.alerts.alertDetails.summary.host.action.openHostDetailsPage', {
  defaultMessage: 'Open host details page'
});
exports.OPEN_HOST_DETAILS_PAGE = OPEN_HOST_DETAILS_PAGE;
const HOST_RISK_SCORE = _i18n.i18n.translate('xpack.securitySolution.alerts.alertDetails.summary.host.riskScore', {
  defaultMessage: 'Host risk score'
});
exports.HOST_RISK_SCORE = HOST_RISK_SCORE;
const HOST_RISK_CLASSIFICATION = _i18n.i18n.translate('xpack.securitySolution.alerts.alertDetails.summary.host.riskClassification', {
  defaultMessage: 'Host risk classification'
});
exports.HOST_RISK_CLASSIFICATION = HOST_RISK_CLASSIFICATION;
const USER_NAME_TITLE = _i18n.i18n.translate('xpack.securitySolution.alerts.alertDetails.summary.user.userName.title', {
  defaultMessage: 'User name'
});
exports.USER_NAME_TITLE = USER_NAME_TITLE;
const USER_RISK_SCORE = _i18n.i18n.translate('xpack.securitySolution.alerts.alertDetails.summary.user.riskScore', {
  defaultMessage: 'User risk score'
});
exports.USER_RISK_SCORE = USER_RISK_SCORE;
const USER_RISK_CLASSIFICATION = _i18n.i18n.translate('xpack.securitySolution.alerts.alertDetails.summary.user.riskClassification', {
  defaultMessage: 'User risk classification'
});
exports.USER_RISK_CLASSIFICATION = USER_RISK_CLASSIFICATION;
const VIEW_USER_SUMMARY = _i18n.i18n.translate('xpack.securitySolution.alerts.alertDetails.summary.user.action.viewUserSummary', {
  defaultMessage: 'View user summary'
});
exports.VIEW_USER_SUMMARY = VIEW_USER_SUMMARY;
const OPEN_USER_DETAILS_PAGE = _i18n.i18n.translate('xpack.securitySolution.alerts.alertDetails.summary.user.action.openUserDetailsPage', {
  defaultMessage: 'Open user details page'
});
exports.OPEN_USER_DETAILS_PAGE = OPEN_USER_DETAILS_PAGE;
const SUMMARY_PANEL_ACTIONS = _i18n.i18n.translate('xpack.securitySolution.alerts.alertDetails.summary.panelMoreActions', {
  defaultMessage: 'More actions'
});
exports.SUMMARY_PANEL_ACTIONS = SUMMARY_PANEL_ACTIONS;