"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.HostPanel = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _fp = require("lodash/fp");
var _timeline = require("../../../../../../../common/types/timeline");
var _endpoint_alert_check = require("../../../../../../common/utils/endpoint_alert_check");
var _summary_value_cell = require("../../../../../../common/components/event_details/table/summary_value_cell");
var _risk_score = require("../../../../../../explore/containers/risk_score");
var _search_strategy = require("../../../../../../../common/search_strategy");
var _empty_value = require("../../../../../../common/components/empty_value");
var _common = require("../../../../../../explore/components/risk_score/severity/common");
var _first_last_seen = require("../../../../../../common/components/first_last_seen");
var _field_renderers = require("../../../../../../timelines/components/field_renderers/field_renderers");
var _links = require("../../../../../../common/components/links");
var _helpers = require("../../../../../../common/components/event_details/helpers");
var _get_timeline_event_data = require("../../../utils/get_timeline_event_data");
var _translation = require("../translation");
var _wrappers = require("../wrappers");
var _host_panel_actions = require("./host_panel_actions");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const HostPanelSection = ({
  grow,
  title,
  children
}) => children ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: grow
}, title && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
  size: "xxs"
}, /*#__PURE__*/_react.default.createElement("h5", null, title)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
  size: "xs"
})), children) : null;
const HostPanel = /*#__PURE__*/_react.default.memo(({
  data,
  id,
  browserFields,
  openHostDetailsPanel,
  selectedPatterns
}) => {
  const hostName = (0, _get_timeline_event_data.getTimelineEventData)('host.name', data);
  const hostOs = (0, _get_timeline_event_data.getTimelineEventData)('host.os.name', data);
  const enrichedAgentStatus = (0, _react.useMemo)(() => {
    const item = (0, _fp.find)({
      field: 'agent.id',
      category: 'agent'
    }, data);
    if (!data || !(0, _endpoint_alert_check.isAlertFromEndpointEvent)({
      data
    })) return null;
    return item && (0, _helpers.getEnrichedFieldInfo)({
      eventId: id,
      contextId: _timeline.TimelineId.detectionsAlertDetailsPage,
      scopeId: _timeline.TimelineId.detectionsAlertDetailsPage,
      browserFields,
      item,
      field: {
        id: 'agent.id',
        overrideField: 'agent.status'
      },
      linkValueField: undefined
    });
  }, [browserFields, data, id]);
  const {
    data: hostRisk,
    isLicenseValid: isRiskLicenseValid
  } = (0, _risk_score.useRiskScore)({
    riskEntity: _search_strategy.RiskScoreEntity.host,
    skip: hostName == null
  });
  const [hostRiskScore, hostRiskLevel] = (0, _react.useMemo)(() => {
    const hostRiskData = hostRisk && hostRisk.length > 0 ? hostRisk[0] : undefined;
    const hostRiskValue = hostRiskData ? Math.round(hostRiskData.host.risk.calculated_score_norm) : (0, _empty_value.getEmptyTagValue)();
    const hostRiskSeverity = hostRiskData ? /*#__PURE__*/_react.default.createElement(_common.RiskScore, {
      severity: hostRiskData.host.risk.calculated_level,
      hideBackgroundColor: true
    }) : (0, _empty_value.getEmptyTagValue)();
    return [hostRiskValue, hostRiskSeverity];
  }, [hostRisk]);
  const hostIpFields = (0, _react.useMemo)(() => {
    var _find$values, _find;
    return (_find$values = (_find = (0, _fp.find)({
      field: 'host.ip',
      category: 'host'
    }, data)) === null || _find === void 0 ? void 0 : _find.values) !== null && _find$values !== void 0 ? _find$values : [];
  }, [data]);
  const renderHostIp = (0, _react.useCallback)(ip => ip != null ? /*#__PURE__*/_react.default.createElement(_links.NetworkDetailsLink, {
    ip: ip
  }) : (0, _empty_value.getEmptyTagValue)(), []);
  const renderHostActions = (0, _react.useCallback)(() => /*#__PURE__*/_react.default.createElement(_host_panel_actions.HostPanelActions, {
    openHostDetailsPanel: openHostDetailsPanel,
    hostName: hostName
  }), [hostName, openHostDetailsPanel]);
  return /*#__PURE__*/_react.default.createElement(_wrappers.SummaryPanel, {
    actionsClassName: _host_panel_actions.HOST_PANEL_ACTIONS_CLASS,
    grow: true,
    renderActionsPopover: hostName ? renderHostActions : undefined,
    title: _translation.HOST_PANEL_TITLE
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    "data-test-subj": "host-panel"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 2
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(HostPanelSection, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "storage",
    size: "xl"
  })), /*#__PURE__*/_react.default.createElement(HostPanelSection, {
    title: _translation.HOST_NAME_TITLE
  }, /*#__PURE__*/_react.default.createElement(_links.HostDetailsLink, {
    hostName: hostName
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    "data-test-subj": "host-panel-agent-status"
  }, /*#__PURE__*/_react.default.createElement(HostPanelSection, {
    title: _translation.OPERATING_SYSTEM_TITLE
  }, hostOs), enrichedAgentStatus && /*#__PURE__*/_react.default.createElement(HostPanelSection, {
    title: _translation.AGENT_STATUS_TITLE
  }, /*#__PURE__*/_react.default.createElement(_summary_value_cell.SummaryValueCell, enrichedAgentStatus))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), isRiskLicenseValid && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    "data-test-subj": "host-panel-risk"
  }, hostRiskScore && /*#__PURE__*/_react.default.createElement(HostPanelSection, {
    title: _translation.HOST_RISK_SCORE
  }, hostRiskScore), hostRiskLevel && /*#__PURE__*/_react.default.createElement(HostPanelSection, {
    title: _translation.HOST_RISK_CLASSIFICATION
  }, hostRiskLevel)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    "data-test-subj": "host-panel-ip"
  }, /*#__PURE__*/_react.default.createElement(HostPanelSection, {
    title: _translation.IP_ADDRESSES_TITLE,
    grow: 2
  }, /*#__PURE__*/_react.default.createElement(_field_renderers.DefaultFieldRenderer, {
    rowItems: hostIpFields,
    attrName: 'host.ip',
    idPrefix: "alert-details-page-user",
    render: renderHostIp
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(HostPanelSection, {
    title: _translation.LAST_SEEN_TITLE,
    grow: 2
  }, /*#__PURE__*/_react.default.createElement(_first_last_seen.FirstLastSeen, {
    indexPatterns: selectedPatterns,
    field: 'host.name',
    value: hostName,
    type: _first_last_seen.FirstLastSeenType.LAST_SEEN
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null))));
});
exports.HostPanel = HostPanel;
HostPanel.displayName = 'HostPanel';