"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getUseCellActionsHook = void 0;
var _react = require("react");
var _securitysolutionDataTable = require("@kbn/securitysolution-data-table");
var _source = require("../../../common/containers/source");
var _cell_actions = require("../../../common/components/cell_actions");
var _constants = require("../../../actions/constants");
var _constants2 = require("../../../../common/constants");
var _sourcerer = require("../../../common/containers/sourcerer");
var _model = require("../../../common/store/sourcerer/model");
var _use_selector = require("../../../common/hooks/use_selector");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getUseCellActionsHook = tableId => {
  const useCellActions = ({
    columns,
    data,
    dataGridRef
  }) => {
    var _useShallowEqualSelec;
    const {
      browserFields
    } = (0, _sourcerer.useSourcererDataView)(_model.SourcererScopeName.detections);
    /**
     * There is difference between how `triggers actions` fetched data v/s
     * how security solution fetches data via timelineSearchStrategy
     *
     * _id and _index fields are array in timelineSearchStrategy  but not in
     * ruleStrategy
     *
     *
     */

    const browserFieldsByName = (0, _react.useMemo)(() => (0, _source.getAllFieldsByName)(browserFields), [browserFields]);
    const finalData = (0, _react.useMemo)(() => data.map(row => row.map(field => {
      let localField = field;
      if (['_id', '_index'].includes(field.field)) {
        var _field$value;
        const newValue = (_field$value = field.value) !== null && _field$value !== void 0 ? _field$value : '';
        localField = {
          field: field.field,
          value: Array.isArray(newValue) ? newValue : [newValue]
        };
      }
      return localField;
    })), [data]);
    const getTable = (0, _react.useMemo)(() => _securitysolutionDataTable.dataTableSelectors.getTableByIdSelector(), []);
    const viewMode = (_useShallowEqualSelec = (0, _use_selector.useShallowEqualSelector)(state => {
      var _getTable;
      return ((_getTable = getTable(state, tableId)) !== null && _getTable !== void 0 ? _getTable : _securitysolutionDataTable.tableDefaults).viewMode;
    })) !== null && _useShallowEqualSelec !== void 0 ? _useShallowEqualSelec : _securitysolutionDataTable.tableDefaults.viewMode;
    const cellActionProps = (0, _react.useMemo)(() => {
      const fields = viewMode === _constants2.VIEW_SELECTION.eventRenderedView ? [] : columns.map(col => {
        var _fieldMeta$type, _fieldMeta$aggregatab;
        const fieldMeta = browserFieldsByName[col.id];
        return {
          name: col.id,
          type: (_fieldMeta$type = fieldMeta === null || fieldMeta === void 0 ? void 0 : fieldMeta.type) !== null && _fieldMeta$type !== void 0 ? _fieldMeta$type : 'keyword',
          values: finalData.map(row => {
            var _row$find$value, _row$find;
            return (_row$find$value = (_row$find = row.find(rowData => rowData.field === col.id)) === null || _row$find === void 0 ? void 0 : _row$find.value) !== null && _row$find$value !== void 0 ? _row$find$value : [];
          }),
          aggregatable: (_fieldMeta$aggregatab = fieldMeta === null || fieldMeta === void 0 ? void 0 : fieldMeta.aggregatable) !== null && _fieldMeta$aggregatab !== void 0 ? _fieldMeta$aggregatab : false
        };
      });
      return {
        triggerId: _constants.SecurityCellActionsTrigger.DEFAULT,
        fields,
        metadata: {
          // cell actions scope
          scopeId: tableId
        },
        dataGridRef
      };
    }, [viewMode, browserFieldsByName, columns, finalData, dataGridRef]);
    const cellActions = (0, _cell_actions.useDataGridColumnsSecurityCellActions)(cellActionProps);
    const getCellActions = (0, _react.useCallback)((_columnId, columnIndex) => {
      if (cellActions.length === 0) return [];
      return cellActions[columnIndex];
    }, [cellActions]);
    return {
      getCellActions,
      visibleCellActions: 3
    };
  };
  return useCellActions;
};
exports.getUseCellActionsHook = getUseCellActionsHook;