"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getBulkActionHook = void 0;
exports.isKnownEmptyQuery = isKnownEmptyQuery;
var _lodash = require("lodash");
var _react = require("react");
var _use_bulk_alert_tags_items = require("../../../common/components/toolbar/bulk_actions/use_bulk_alert_tags_items");
var _use_selector = require("../../../common/hooks/use_selector");
var _store = require("../../../common/store");
var _model = require("../../../common/store/sourcerer/model");
var _use_global_time = require("../../../common/containers/use_global_time");
var _use_add_bulk_to_timeline = require("../../components/alerts_table/timeline_actions/use_add_bulk_to_timeline");
var _use_alert_actions = require("./use_alert_actions");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// check to see if the query is a known "empty" shape
function isKnownEmptyQuery(query) {
  const queries = [
  // the default query used by the job wizards
  {
    bool: {
      must: [{
        match_all: {}
      }]
    }
  },
  // the default query used created by lens created jobs
  {
    bool: {
      filter: [],
      must: [{
        match_all: {}
      }],
      must_not: []
    }
  },
  // variations on the two previous queries
  {
    bool: {
      filter: [],
      must: [{
        match_all: {}
      }]
    }
  }, {
    bool: {
      must: [{
        match_all: {}
      }],
      must_not: []
    }
  },
  // the query generated by QA Framework created jobs
  {
    match_all: {}
  }];
  if (queries.some(q => (0, _lodash.isEqual)(q, query))) {
    return true;
  }
  return false;
}
function getFiltersForDSLQuery(datafeedQuery) {
  if (isKnownEmptyQuery(datafeedQuery)) {
    return [];
  }
  return [{
    meta: {
      negate: false,
      disabled: false,
      type: 'custom',
      value: JSON.stringify(datafeedQuery)
    },
    query: datafeedQuery
  }];
}
const getBulkActionHook = tableId => query => {
  const {
    from,
    to
  } = (0, _use_global_time.useGlobalTime)();
  const filters = getFiltersForDSLQuery(query);
  const getGlobalQueries = _store.inputsSelectors.globalQuery();
  const globalQuery = (0, _use_selector.useShallowEqualSelector)(state => getGlobalQueries(state));
  const refetchGlobalQuery = (0, _react.useCallback)(() => {
    globalQuery.forEach(q => q.refetch && q.refetch());
  }, [globalQuery]);
  const timelineAction = (0, _use_add_bulk_to_timeline.useAddBulkToTimelineAction)({
    localFilters: filters,
    from,
    to,
    scopeId: _model.SourcererScopeName.detections,
    tableId
  });
  const alertActions = (0, _use_alert_actions.useBulkAlertActionItems)({
    scopeId: _model.SourcererScopeName.detections,
    filters,
    from,
    to,
    tableId,
    refetch: refetchGlobalQuery
  });
  const {
    alertTagsItems,
    alertTagsPanels
  } = (0, _use_bulk_alert_tags_items.useBulkAlertTagsItems)({
    refetch: refetchGlobalQuery
  });
  const items = [...alertActions, timelineAction, ...alertTagsItems];
  return [{
    id: 0,
    items
  }, ...alertTagsPanels];
};
exports.getBulkActionHook = getBulkActionHook;