"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.stepActionsDefaultValue = exports.StepRuleActionsReadOnly = exports.StepRuleActions = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _hook_form_lib = require("@kbn/es-ui-shared-plugin/static/forms/hook_form_lib");
var _utils = require("../../../../../common/detection_engine/utils");
var _use_experimental_features = require("../../../../common/hooks/use_experimental_features");
var _response_actions_form = require("../../../../detection_engine/rule_response_actions/response_actions_form");
var _shared_imports = require("../../../../shared_imports");
var _step_content_wrapper = require("../step_content_wrapper");
var _rule_actions_field = require("../rule_actions_field");
var _kibana = require("../../../../common/lib/kibana");
var _use_fetch_connectors = require("../../../../detection_engine/rule_management/api/hooks/use_fetch_connectors");
var i18n = _interopRequireWildcard(require("./translations"));
var _rule_snooze_section = require("./rule_snooze_section");
var _notification_action = require("./notification_action");
var _response_action = require("./response_action");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const stepActionsDefaultValue = {
  enabled: true,
  actions: [],
  responseActions: [],
  kibanaSiemAppUrl: ''
};
exports.stepActionsDefaultValue = stepActionsDefaultValue;
const GhostFormField = () => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null);
const DisplayActionsHeader = () => {
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("h4", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    defaultMessage: "Actions",
    id: "xpack.securitySolution.detectionEngine.rule.editRule.actionSectionsTitle"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }));
};
const StepRuleActionsComponent = ({
  ruleId,
  isUpdateView = false,
  actionMessageParams,
  summaryActionMessageParams,
  ruleType,
  form
}) => {
  const {
    services: {
      application
    }
  } = (0, _kibana.useKibana)();
  const responseActionsEnabled = (0, _use_experimental_features.useIsExperimentalFeatureEnabled)('responseActionsEnabled');
  const displayActionsOptions = (0, _react.useMemo)(() => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_shared_imports.UseField, {
    path: "actions",
    component: _rule_actions_field.RuleActionsField,
    componentProps: {
      messageVariables: actionMessageParams,
      summaryMessageVariables: summaryActionMessageParams
    }
  })), [actionMessageParams, summaryActionMessageParams]);
  const displayResponseActionsOptions = (0, _react.useMemo)(() => {
    if ((0, _utils.isQueryRule)(ruleType)) {
      return /*#__PURE__*/_react.default.createElement(_hook_form_lib.UseArray, {
        path: "responseActions",
        initialNumberOfItems: 0
      }, _response_actions_form.ResponseActionsForm);
    }
    return null;
  }, [ruleType]);
  // only display the actions dropdown if the user has "read" privileges for actions
  const displayActionsDropDown = (0, _react.useMemo)(() => {
    return application.capabilities.actions.show ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(DisplayActionsHeader, null), ruleId && /*#__PURE__*/_react.default.createElement(_rule_snooze_section.RuleSnoozeSection, {
      ruleId: ruleId
    }), displayActionsOptions, responseActionsEnabled && displayResponseActionsOptions, /*#__PURE__*/_react.default.createElement(_shared_imports.UseField, {
      path: "kibanaSiemAppUrl",
      component: GhostFormField
    }), /*#__PURE__*/_react.default.createElement(_shared_imports.UseField, {
      path: "enabled",
      component: GhostFormField
    })) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, i18n.NO_ACTIONS_READ_PERMISSIONS));
  }, [ruleId, application.capabilities.actions.show, displayActionsOptions, displayResponseActionsOptions, responseActionsEnabled]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_step_content_wrapper.StepContentWrapper, {
    addPadding: !isUpdateView
  }, /*#__PURE__*/_react.default.createElement(_shared_imports.Form, {
    form: form,
    "data-test-subj": "stepRuleActions"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiForm, null, displayActionsDropDown))));
};
const StepRuleActions = /*#__PURE__*/(0, _react.memo)(StepRuleActionsComponent);
exports.StepRuleActions = StepRuleActions;
const StepRuleActionsReadOnlyComponent = ({
  addPadding,
  defaultValues: ruleActionsData
}) => {
  const {
    services: {
      triggersActionsUi
    }
  } = (0, _kibana.useKibana)();
  const actionTypeRegistry = triggersActionsUi.actionTypeRegistry;
  const {
    data: connectors
  } = (0, _use_fetch_connectors.useFetchConnectors)();
  const {
    data: connectorTypes
  } = (0, _use_fetch_connectors.useFetchConnectorTypes)();
  const notificationActions = ruleActionsData.actions;
  const responseActions = ruleActionsData.responseActions || [];
  const ruleHasActions = notificationActions.length > 0 || responseActions.length > 0;
  if (!ruleHasActions || !connectors || !connectorTypes) {
    return null;
  }
  const hasBothNotificationAndResponseActions = notificationActions.length > 0 && responseActions.length > 0;
  return /*#__PURE__*/_react.default.createElement(_step_content_wrapper.StepContentWrapper, {
    addPadding: addPadding
  }, notificationActions.length > 0 && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "m"
  }, i18n.NOTIFICATION_ACTIONS), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  })), notificationActions.map((action, index) => {
    const isLastItem = index === notificationActions.length - 1;
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_notification_action.NotificationAction, {
      action: action,
      connectorTypes: connectorTypes,
      connectors: connectors,
      actionTypeRegistry: actionTypeRegistry,
      key: action.id
    }), !isLastItem && /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s"
    }));
  }), hasBothNotificationAndResponseActions && /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), responseActions.length > 0 && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "m"
  }, i18n.RESPONSE_ACTIONS), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  })), responseActions.map((action, index) => {
    const isLastItem = index === responseActions.length - 1;
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_response_action.ResponseAction, {
      action: action,
      key: `${action.actionTypeId}-${index}`
    }), !isLastItem && /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s"
    }));
  }));
};
const StepRuleActionsReadOnly = /*#__PURE__*/(0, _react.memo)(StepRuleActionsReadOnlyComponent);
exports.StepRuleActionsReadOnly = StepRuleActionsReadOnly;