"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MlAdminJobsDescription = void 0;
var _react = _interopRequireWildcard(require("react"));
var _use_security_jobs = require("../../../../../common/components/ml_popover/hooks/use_security_jobs");
var _ml_admin_job_description = require("./ml_admin_job_description");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const MlAdminJobsDescriptionComponent = ({
  jobIds
}) => {
  const {
    loading,
    jobs,
    refetch: refreshJobs,
    isMlAdmin
  } = (0, _use_security_jobs.useSecurityJobs)();
  if (!isMlAdmin) {
    return null;
  }
  const relevantJobs = jobs.filter(job => jobIds.includes(job.id));
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, relevantJobs.map(job => /*#__PURE__*/_react.default.createElement(_ml_admin_job_description.MlAdminJobDescription, {
    key: job.id,
    job: job,
    loading: loading,
    refreshJob: refreshJobs
  })));
};
const MlAdminJobsDescription = /*#__PURE__*/(0, _react.memo)(MlAdminJobsDescriptionComponent);
exports.MlAdminJobsDescription = MlAdminJobsDescription;