"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MitreAttackSubtechniqueFields = void 0;
var _eui = require("@elastic/eui");
var _fp = require("lodash/fp");
var _react = _interopRequireWildcard(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var Rulei18n = _interopRequireWildcard(require("../../../pages/detection_engine/rules/translations"));
var _add_item_form = require("../add_item_form");
var i18n = _interopRequireWildcard(require("./translations"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
const lazyMitreConfiguration = () => {
  /**
   * The specially formatted comment in the `import` expression causes the corresponding webpack chunk to be named. This aids us in debugging chunk size issues.
   * See https://webpack.js.org/api/module-methods/#magic-comments
   */
  return Promise.resolve().then(() => _interopRequireWildcard(require( /* webpackChunkName: "lazy_mitre_configuration" */
  '../../../mitre/mitre_tactics_techniques')));
};
const SubtechniqueContainer = _styledComponents.default.div`
  margin-left: 48px;
`;
const MitreAttackSubtechniqueFields = ({
  field,
  idAria,
  isDisabled,
  threatIndex,
  techniqueIndex,
  onFieldChange
}) => {
  const values = field.value;
  const [subtechniquesOptions, setSubtechniquesOptions] = (0, _react.useState)([]);
  (0, _react.useEffect)(() => {
    async function getMitre() {
      const mitreConfig = await lazyMitreConfiguration();
      setSubtechniquesOptions(mitreConfig.subtechniquesOptions);
    }
    getMitre();
  }, []);
  const technique = (0, _react.useMemo)(() => {
    var _values$threatIndex$t;
    return [...((_values$threatIndex$t = values[threatIndex].technique) !== null && _values$threatIndex$t !== void 0 ? _values$threatIndex$t : [])];
  }, [values, threatIndex]);
  const removeSubtechnique = (0, _react.useCallback)(index => {
    var _technique$techniqueI;
    const threats = [...field.value];
    const subtechniques = (_technique$techniqueI = technique[techniqueIndex].subtechnique) !== null && _technique$techniqueI !== void 0 ? _technique$techniqueI : [];
    if (subtechniques != null) {
      subtechniques.splice(index, 1);
      technique[techniqueIndex] = {
        ...technique[techniqueIndex],
        subtechnique: subtechniques
      };
      threats[threatIndex].technique = technique;
      onFieldChange(threats);
    }
  }, [field, onFieldChange, techniqueIndex, technique, threatIndex]);
  const addMitreAttackSubtechnique = (0, _react.useCallback)(() => {
    const threats = [...field.value];
    const subtechniques = technique[techniqueIndex].subtechnique;
    if (subtechniques != null) {
      technique[techniqueIndex] = {
        ...technique[techniqueIndex],
        subtechnique: [...subtechniques, {
          id: 'none',
          name: 'none',
          reference: 'none'
        }]
      };
    } else {
      technique[techniqueIndex] = {
        ...technique[techniqueIndex],
        subtechnique: [{
          id: 'none',
          name: 'none',
          reference: 'none'
        }]
      };
    }
    threats[threatIndex].technique = technique;
    onFieldChange(threats);
  }, [field, onFieldChange, techniqueIndex, technique, threatIndex]);
  const updateSubtechnique = (0, _react.useCallback)((index, value) => {
    const threats = [...field.value];
    const {
      id,
      reference,
      name
    } = subtechniquesOptions.find(t => t.value === value) || {
      id: '',
      name: '',
      reference: ''
    };
    const subtechniques = technique[techniqueIndex].subtechnique;
    if (subtechniques != null) {
      onFieldChange([...threats.slice(0, threatIndex), {
        ...threats[threatIndex],
        technique: [...technique.slice(0, techniqueIndex), {
          ...technique[techniqueIndex],
          subtechnique: [...subtechniques.slice(0, index), {
            id,
            reference,
            name
          }, ...subtechniques.slice(index + 1)]
        }, ...technique.slice(techniqueIndex + 1)]
      }, ...threats.slice(threatIndex + 1)]);
    }
  }, [field.value, subtechniquesOptions, technique, techniqueIndex, onFieldChange, threatIndex]);
  const getSelectSubtechnique = (0, _react.useCallback)((index, disabled, subtechnique) => {
    const options = subtechniquesOptions.filter(t => t.techniqueId === technique[techniqueIndex].id);
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSuperSelect, {
      id: "mitreAttackSubtechnique",
      options: [...(subtechnique.name === 'none' ? [{
        inputDisplay: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, i18n.SUBTECHNIQUE_PLACEHOLDER),
        value: 'none',
        disabled
      }] : []), ...options.map(option => ({
        inputDisplay: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, option.label),
        value: option.value,
        disabled
      }))],
      prepend: `${field.label} ${i18n.SUBTECHNIQUE}`,
      "aria-label": "",
      onChange: updateSubtechnique.bind(null, index),
      fullWidth: true,
      valueOfSelected: (0, _fp.camelCase)(subtechnique.name),
      "data-test-subj": "mitreAttackSubtechnique",
      disabled: disabled,
      placeholder: i18n.SUBTECHNIQUE_PLACEHOLDER
    }));
  }, [subtechniquesOptions, field.label, updateSubtechnique, technique, techniqueIndex]);
  const subtechniques = (0, _react.useMemo)(() => {
    return technique[techniqueIndex].subtechnique;
  }, [technique, techniqueIndex]);
  return /*#__PURE__*/_react.default.createElement(SubtechniqueContainer, null, subtechniques != null && subtechniques.map((subtechnique, index) => /*#__PURE__*/_react.default.createElement("div", {
    key: index
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    describedByIds: idAria ? [`${idAria} ${i18n.SUBTECHNIQUE}`] : undefined
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true
  }, getSelectSubtechnique(index, isDisabled, subtechnique)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    color: "danger",
    iconType: "trash",
    isDisabled: isDisabled,
    onClick: () => removeSubtechnique(index),
    "aria-label": Rulei18n.DELETE
  })))))), /*#__PURE__*/_react.default.createElement(_add_item_form.MyAddItemButton, {
    "data-test-subj": "addMitreAttackSubtechnique",
    onClick: addMitreAttackSubtechnique,
    isDisabled: isDisabled
  }, i18n.ADD_MITRE_SUBTECHNIQUE));
};
exports.MitreAttackSubtechniqueFields = MitreAttackSubtechniqueFields;