"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getValidationResults = exports.eqlValidator = exports.debounceAsync = exports.ERROR_CODES = void 0;
var _lodash = require("lodash");
var _utils = require("../../../../../common/detection_engine/utils");
var _kibana = require("../../../../common/lib/kibana");
var _types = require("../../../pages/detection_engine/rules/types");
var _api = require("../../../../common/hooks/eql/api");
var i18n = _interopRequireWildcard(require("./translations"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
let ERROR_CODES;
/**
 * Unlike lodash's debounce, which resolves intermediate calls with the most
 * recent value, this implementation waits to resolve intermediate calls until
 * the next invocation resolves.
 *
 * @param fn an async function
 *
 * @returns A debounced async function that resolves on the next invocation
 */
exports.ERROR_CODES = ERROR_CODES;
(function (ERROR_CODES) {
  ERROR_CODES["FAILED_REQUEST"] = "ERR_FAILED_REQUEST";
  ERROR_CODES["INVALID_EQL"] = "ERR_INVALID_EQL";
})(ERROR_CODES || (exports.ERROR_CODES = ERROR_CODES = {}));
const debounceAsync = (fn, interval) => {
  let handle;
  let resolves = [];
  return (...args) => {
    if (handle) {
      clearTimeout(handle);
    }
    handle = setTimeout(() => {
      const result = fn(...args);
      resolves.forEach(resolve => resolve(result));
      resolves = [];
    }, interval);
    return new Promise(resolve => resolves.push(resolve));
  };
};
exports.debounceAsync = debounceAsync;
const eqlValidator = async (...args) => {
  const [{
    value,
    formData
  }] = args;
  const {
    query: queryValue
  } = value;
  const query = queryValue.query;
  const {
    dataViewId,
    index,
    ruleType
  } = formData;
  const needsValidation = ruleType === undefined && !(0, _lodash.isEmpty)(query) || (0, _utils.isEqlRule)(ruleType) && !(0, _lodash.isEmpty)(query);
  if (!needsValidation) {
    return;
  }
  try {
    const {
      data
    } = _kibana.KibanaServices.get();
    let dataViewTitle = index === null || index === void 0 ? void 0 : index.join();
    let runtimeMappings = {};
    if (dataViewId != null && dataViewId !== '' && formData.dataSourceType === _types.DataSourceType.DataView) {
      const dataView = await data.dataViews.get(dataViewId);
      dataViewTitle = dataView.title;
      runtimeMappings = dataView.getRuntimeMappings();
    }
    const signal = new AbortController().signal;
    const response = await (0, _api.validateEql)({
      data,
      query,
      signal,
      dataViewTitle,
      runtimeMappings
    });
    if ((response === null || response === void 0 ? void 0 : response.valid) === false) {
      return {
        code: ERROR_CODES.INVALID_EQL,
        message: '',
        messages: response.errors
      };
    }
  } catch (error) {
    return {
      code: ERROR_CODES.FAILED_REQUEST,
      message: i18n.EQL_VALIDATION_REQUEST_ERROR,
      error
    };
  }
};
exports.eqlValidator = eqlValidator;
const getValidationResults = field => {
  const hasErrors = field.errors.length > 0;
  const isValid = !field.isChangingValue && !hasErrors;
  if (hasErrors) {
    const [error] = field.errors;
    const message = error.message;
    if (error.code === ERROR_CODES.INVALID_EQL) {
      return {
        isValid,
        message,
        messages: error.messages
      };
    } else {
      return {
        isValid,
        message,
        error: error.error
      };
    }
  } else {
    return {
      isValid,
      message: ''
    };
  }
};
exports.getValidationResults = getValidationResults;