"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getDescriptionItem = exports.buildListItems = exports.addFilterStateIfNotThere = exports.StepRuleDescriptionComponent = exports.StepRuleDescription = void 0;
var _eui = require("@elastic/eui");
var _fp = require("lodash/fp");
var _react = _interopRequireWildcard(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _esQuery = require("@kbn/es-query");
var _public = require("@kbn/data-plugin/public");
var _integrations_description = require("../related_integrations/integrations_description");
var _translations = require("../../../../timelines/components/timeline/translations");
var _kibana = require("../../../../common/lib/kibana");
var _helpers = require("./helpers");
var _build_ml_jobs_description = require("./build_ml_jobs_description");
var _actions_description = require("./actions_description");
var _throttle_description = require("./throttle_description");
var _translations2 = require("./translations");
var _helpers2 = require("../../../../detection_engine/rule_creation_ui/pages/rule_creation/helpers");
var _use_license = require("../../../../common/hooks/use_license");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DescriptionListContainer = (0, _styledComponents.default)(_eui.EuiDescriptionList)`
  max-width: 600px;
  &.euiDescriptionList--column .euiDescriptionList__title {
    width: 30%;
  }
  &.euiDescriptionList--column .euiDescriptionList__description {
    width: 70%;
    overflow-wrap: anywhere;
  }
`;
const StepRuleDescriptionComponent = ({
  data,
  columns = 'multi',
  indexPatterns,
  schema
}) => {
  const kibana = (0, _kibana.useKibana)();
  const license = (0, _use_license.useLicense)();
  const [filterManager] = (0, _react.useState)(new _public.FilterManager(kibana.services.uiSettings));
  const keys = Object.keys(schema);
  const listItems = keys.reduce((acc, key) => {
    if (key === 'machineLearningJobId') {
      return [...acc, (0, _build_ml_jobs_description.buildMlJobsDescription)((0, _fp.get)(key, data), (0, _fp.get)(key, schema).label)];
    }
    if (key === 'throttle') {
      return [...acc, (0, _throttle_description.buildThrottleDescription)((0, _fp.get)(key, data), (0, _fp.get)([key, 'label'], schema))];
    }
    if (key === 'actions') {
      return [...acc, (0, _actions_description.buildActionsDescription)((0, _fp.get)(key, data), (0, _fp.get)([key, 'label'], schema))];
    }
    return [...acc, ...buildListItems(data, (0, _fp.pick)(key, schema), filterManager, license, indexPatterns)];
  }, []);
  if (columns === 'multi') {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, (0, _fp.chunk)(Math.ceil(listItems.length / 2), listItems).map((chunkListItems, index) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      "data-test-subj": "listItemColumnStepRuleDescription",
      key: `description-step-rule-${index}`
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
      listItems: chunkListItems
    }))));
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    "data-test-subj": "listItemColumnStepRuleDescription"
  }, columns === 'single' ? /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
    listItems: listItems
  }) : /*#__PURE__*/_react.default.createElement(DescriptionListContainer, {
    "data-test-subj": "singleSplitStepRuleDescriptionList",
    type: "column",
    listItems: listItems
  })));
};
exports.StepRuleDescriptionComponent = StepRuleDescriptionComponent;
const StepRuleDescription = /*#__PURE__*/(0, _react.memo)(StepRuleDescriptionComponent);
exports.StepRuleDescription = StepRuleDescription;
const buildListItems = (data, schema, filterManager, license, indexPatterns) => Object.keys(schema).reduce((acc, field) => [...acc, ...getDescriptionItem(field, (0, _fp.get)([field, 'label'], schema), data, filterManager, license, indexPatterns)], []);
exports.buildListItems = buildListItems;
const addFilterStateIfNotThere = filters => {
  return filters.map(filter => {
    if (filter.$state == null) {
      return {
        $state: {
          store: _esQuery.FilterStateStore.APP_STATE
        },
        ...filter
      };
    } else {
      return filter;
    }
  });
};

/* eslint complexity: ["error", 25]*/
// eslint-disable-next-line complexity
exports.addFilterStateIfNotThere = addFilterStateIfNotThere;
const getDescriptionItem = (field, label, data, filterManager, license, indexPatterns) => {
  if (field === 'queryBar') {
    var _get;
    const filters = addFilterStateIfNotThere((_get = (0, _fp.get)('queryBar.filters', data)) !== null && _get !== void 0 ? _get : []);
    const query = (0, _fp.get)('queryBar.query.query', data);
    const savedId = (0, _fp.get)('queryBar.saved_id', data);
    const savedQueryName = (0, _fp.get)('queryBar.title', data);
    return (0, _helpers.buildQueryBarDescription)({
      field,
      filters,
      filterManager,
      query,
      savedId,
      savedQueryName,
      indexPatterns
    });
  } else if (field === 'responseActions') {
    return [];
  } else if (field === 'groupByFields') {
    const values = (0, _fp.get)(field, data);
    return (0, _helpers.buildAlertSuppressionDescription)(label, values, license);
  } else if (field === 'groupByRadioSelection') {
    return [];
  } else if (field === 'groupByDuration') {
    if ((0, _fp.get)('groupByFields', data).length > 0) {
      const value = (0, _fp.get)(field, data);
      return (0, _helpers.buildAlertSuppressionWindowDescription)(label, value, license, (0, _fp.get)('groupByRadioSelection', data));
    } else {
      return [];
    }
  } else if (field === 'suppressionMissingFields') {
    if ((0, _fp.get)('groupByFields', data).length > 0) {
      const value = (0, _fp.get)(field, data);
      return (0, _helpers.buildAlertSuppressionMissingFieldsDescription)(label, value, license);
    } else {
      return [];
    }
  } else if (field === 'eqlOptions') {
    const eqlOptions = (0, _fp.get)(field, data);
    return (0, _helpers.buildEqlOptionsDescription)(eqlOptions);
  } else if (field === 'threat') {
    const threats = (0, _fp.get)(field, data);
    return (0, _helpers.buildThreatDescription)({
      label,
      threat: (0, _helpers2.filterEmptyThreats)(threats)
    });
  } else if (field === 'threshold') {
    const threshold = (0, _fp.get)(field, data);
    return (0, _helpers.buildThresholdDescription)(label, threshold);
  } else if (field === 'references') {
    const urls = (0, _fp.get)(field, data);
    return (0, _helpers.buildUrlsDescription)(label, urls);
  } else if (field === 'falsePositives') {
    const values = (0, _fp.get)(field, data);
    return (0, _helpers.buildUnorderedListArrayDescription)(label, field, values);
  } else if (field === 'riskScore') {
    const values = (0, _fp.get)(field, data);
    return (0, _helpers.buildRiskScoreDescription)(values);
  } else if (field === 'severity') {
    const values = (0, _fp.get)(field, data);
    return (0, _helpers.buildSeverityDescription)(values);
  } else if (field === 'requiredFields') {
    const requiredFields = (0, _fp.get)(field, data);
    return (0, _helpers.buildRequiredFieldsDescription)(label, requiredFields);
  } else if (field === 'relatedIntegrations') {
    const relatedIntegrations = (0, _fp.get)(field, data);
    return (0, _integrations_description.buildRelatedIntegrationsDescription)(label, relatedIntegrations);
  } else if (field === 'timeline') {
    var _timeline$title;
    const timeline = (0, _fp.get)(field, data);
    return [{
      title: label,
      description: (_timeline$title = timeline.title) !== null && _timeline$title !== void 0 ? _timeline$title : _translations.DEFAULT_TIMELINE_TITLE
    }];
  } else if (field === 'note') {
    const val = (0, _fp.get)(field, data);
    return (0, _helpers.buildNoteDescription)(label, val);
  } else if (field === 'ruleType') {
    const ruleType = (0, _fp.get)(field, data);
    return (0, _helpers.buildRuleTypeDescription)(label, ruleType);
  } else if (field === 'kibanaSiemAppUrl') {
    return [];
  } else if (field === 'threatQueryBar') {
    var _get2;
    const filters = addFilterStateIfNotThere((_get2 = (0, _fp.get)('threatQueryBar.filters', data)) !== null && _get2 !== void 0 ? _get2 : []);
    const query = (0, _fp.get)('threatQueryBar.query.query', data);
    const savedId = (0, _fp.get)('threatQueryBar.saved_id', data);
    return (0, _helpers.buildQueryBarDescription)({
      field,
      filters,
      filterManager,
      query,
      savedId,
      indexPatterns,
      queryLabel: _translations2.THREAT_QUERY_LABEL
    });
  } else if (field === 'threatMapping') {
    const threatMap = (0, _fp.get)(field, data);
    return (0, _helpers.buildThreatMappingDescription)(label, threatMap);
  } else if (Array.isArray((0, _fp.get)(field, data)) && field !== 'threatMapping') {
    const values = (0, _fp.get)(field, data);
    return (0, _helpers.buildStringArrayDescription)(label, field, values);
  } else if (field === 'index') {
    if ((0, _fp.get)('dataViewId', data)) {
      return [];
    }
  }
  const description = (0, _fp.get)(field, data);
  if ((0, _fp.isNumber)(description) || !(0, _fp.isEmpty)(description)) {
    return [{
      title: label,
      description
    }];
  }
  return [];
};
exports.getDescriptionItem = getDescriptionItem;