"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MlJobUpgradeModal = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _polished = require("polished");
var i18n = _interopRequireWildcard(require("./translations"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const JobsUL = _styledComponents.default.ul`
  max-height: 200px;
  overflow-y: auto;

  &::-webkit-scrollbar {
    height: ${({
  theme
}) => theme.eui.euiScrollBar};
    width: ${({
  theme
}) => theme.eui.euiScrollBar};
  }

  &::-webkit-scrollbar-thumb {
    background-clip: content-box;
    background-color: ${({
  theme
}) => (0, _polished.rgba)(theme.eui.euiColorDarkShade, 0.5)};
    border: ${({
  theme
}) => theme.eui.euiScrollBarCorner} solid transparent;
  }

  &::-webkit-scrollbar-corner,
  &::-webkit-scrollbar-track {
    background-color: transparent;
  }
`;
const MlJobUpgradeModalComponent = ({
  jobs,
  onCancel,
  onConfirm
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiConfirmModal, {
    title: i18n.ML_JOB_UPGRADE_MODAL_TITLE,
    onCancel: onCancel,
    onConfirm: onConfirm,
    cancelButtonText: i18n.ML_JOB_UPGRADE_MODAL_CANCEL,
    confirmButtonText: i18n.ML_JOB_UPGRADE_MODAL_CONFIRM,
    buttonColor: "danger",
    defaultFocusedButton: "confirm"
  }, /*#__PURE__*/_react.default.createElement(i18n.MlJobUpgradeModalBody, null), i18n.ML_JOB_UPGRADE_MODAL_AFFECTED_JOBS, /*#__PURE__*/_react.default.createElement(JobsUL, null, jobs.map(j => {
    return /*#__PURE__*/_react.default.createElement("li", {
      key: j.id
    }, j.id);
  })));
};
const MlJobUpgradeModal = /*#__PURE__*/(0, _react.memo)(MlJobUpgradeModalComponent);
exports.MlJobUpgradeModal = MlJobUpgradeModal;