"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useHostIsolationAction = void 0;
var _react = require("react");
var _utils = require("../../../../common/endpoint/service/host_isolation/utils");
var _types = require("../../../../common/endpoint/types");
var _endpoint_alert_check = require("../../../common/utils/endpoint_alert_check");
var _use_host_isolation_status = require("../../containers/detection_engine/alerts/use_host_isolation_status");
var _translations = require("./translations");
var _helpers = require("./helpers");
var _user_privileges = require("../../../common/components/user_privileges");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useHostIsolationAction = ({
  closePopover,
  detailsData,
  isHostIsolationPanelOpen,
  onAddIsolationStatusClick
}) => {
  const isEndpointAlert = (0, _react.useMemo)(() => {
    return (0, _endpoint_alert_check.isAlertFromEndpointEvent)({
      data: detailsData || []
    });
  }, [detailsData]);
  const agentId = (0, _react.useMemo)(() => (0, _helpers.getFieldValue)({
    category: 'agent',
    field: 'agent.id'
  }, detailsData), [detailsData]);
  const hostOsFamily = (0, _react.useMemo)(() => (0, _helpers.getFieldValue)({
    category: 'host',
    field: 'host.os.name'
  }, detailsData), [detailsData]);
  const agentVersion = (0, _react.useMemo)(() => (0, _helpers.getFieldValue)({
    category: 'agent',
    field: 'agent.version'
  }, detailsData), [detailsData]);
  const {
    loading: loadingHostIsolationStatus,
    isIsolated: isolationStatus,
    agentStatus,
    capabilities
  } = (0, _use_host_isolation_status.useHostIsolationStatus)({
    agentId
  });
  const isolationSupported = (0, _react.useMemo)(() => {
    return isEndpointAlert ? (0, _utils.isIsolationSupported)({
      osName: hostOsFamily,
      version: agentVersion,
      capabilities
    }) : false;
  }, [agentVersion, capabilities, hostOsFamily, isEndpointAlert]);
  const isIsolationAllowed = (0, _user_privileges.useUserPrivileges)().endpointPrivileges.canIsolateHost;
  const isolateHostHandler = (0, _react.useCallback)(() => {
    closePopover();
    if (isolationStatus === false) {
      onAddIsolationStatusClick('isolateHost');
    } else {
      onAddIsolationStatusClick('unisolateHost');
    }
  }, [closePopover, isolationStatus, onAddIsolationStatusClick]);
  const isolateHostTitle = isolationStatus === false ? _translations.ISOLATE_HOST : _translations.UNISOLATE_HOST;
  const hostIsolationAction = (0, _react.useMemo)(() => isIsolationAllowed && isEndpointAlert && isolationSupported && isHostIsolationPanelOpen === false && loadingHostIsolationStatus === false ? [{
    key: 'isolate-host-action-item',
    'data-test-subj': 'isolate-host-action-item',
    disabled: agentStatus === _types.HostStatus.UNENROLLED,
    onClick: isolateHostHandler,
    name: isolateHostTitle
  }] : [], [agentStatus, isEndpointAlert, isHostIsolationPanelOpen, isIsolationAllowed, isolateHostHandler, isolateHostTitle, isolationSupported, loadingHostIsolationStatus]);
  return hostIsolationAction;
};
exports.useHostIsolationAction = useHostIsolationAction;