"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.requiredFieldsForActions = exports.getAlertsPreviewDefaultModel = exports.getAlertsDefaultModel = exports.buildThreatMatchFilter = exports.buildShowBuildingBlockFilter = exports.buildAlertsFilter = exports.buildAlertStatusesFilter = exports.buildAlertStatusFilter = void 0;
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _securitysolutionDataTable = require("@kbn/securitysolution-data-table");
var _columns = require("../../configurations/security_solution_detections/columns");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const buildAlertStatusFilter = status => {
  const combinedQuery = status === 'acknowledged' ? {
    bool: {
      should: [{
        term: {
          [_ruleDataUtils.ALERT_WORKFLOW_STATUS]: status
        }
      }, {
        term: {
          [_ruleDataUtils.ALERT_WORKFLOW_STATUS]: 'in-progress'
        }
      }]
    }
  } : {
    term: {
      [_ruleDataUtils.ALERT_WORKFLOW_STATUS]: status
    }
  };
  return [{
    meta: {
      alias: null,
      negate: false,
      disabled: false,
      type: 'phrase',
      key: _ruleDataUtils.ALERT_WORKFLOW_STATUS,
      params: {
        query: status
      }
    },
    query: combinedQuery
  }];
};

/**
 * For backwards compatability issues, if `acknowledged` is a status prop, `in-progress` will likely have to be too
 */
exports.buildAlertStatusFilter = buildAlertStatusFilter;
const buildAlertStatusesFilter = statuses => {
  const combinedQuery = {
    bool: {
      should: statuses.map(status => ({
        term: {
          [_ruleDataUtils.ALERT_WORKFLOW_STATUS]: status
        }
      }))
    }
  };
  return [{
    meta: {
      alias: null,
      negate: false,
      disabled: false
    },
    query: combinedQuery
  }];
};

/**
 * Builds Kuery filter for fetching alerts for a specific rule. Takes the rule's
 * static id, i.e. `rule.ruleId` (not rule.id), so that alerts for _all
 * historical instances_ of the rule are returned.
 *
 * @param ruleStaticId Rule's static id: `rule.ruleId`
 */
exports.buildAlertStatusesFilter = buildAlertStatusesFilter;
const buildAlertsFilter = ruleStaticId => ruleStaticId ? [{
  meta: {
    alias: null,
    negate: false,
    disabled: false,
    type: 'phrase',
    key: _ruleDataUtils.ALERT_RULE_RULE_ID,
    params: {
      query: ruleStaticId
    }
  },
  query: {
    match_phrase: {
      [_ruleDataUtils.ALERT_RULE_RULE_ID]: ruleStaticId
    }
  }
}] : [];
exports.buildAlertsFilter = buildAlertsFilter;
const buildShowBuildingBlockFilter = showBuildingBlockAlerts => showBuildingBlockAlerts ? [] : [{
  meta: {
    alias: null,
    negate: true,
    disabled: false,
    type: 'exists',
    key: _ruleDataUtils.ALERT_BUILDING_BLOCK_TYPE,
    value: 'exists'
  },
  query: {
    exists: {
      field: _ruleDataUtils.ALERT_BUILDING_BLOCK_TYPE
    }
  }
}];
exports.buildShowBuildingBlockFilter = buildShowBuildingBlockFilter;
const buildThreatMatchFilter = showOnlyThreatIndicatorAlerts => showOnlyThreatIndicatorAlerts ? [{
  meta: {
    alias: null,
    disabled: false,
    negate: false,
    key: 'kibana.alert.rule.type',
    type: 'term'
  },
  query: {
    term: {
      'kibana.alert.rule.type': 'threat_match'
    }
  }
}] : [];
exports.buildThreatMatchFilter = buildThreatMatchFilter;
const getAlertsDefaultModel = license => ({
  ..._securitysolutionDataTable.tableDefaults,
  columns: (0, _columns.getColumns)(license),
  showCheckboxes: true
});
exports.getAlertsDefaultModel = getAlertsDefaultModel;
const getAlertsPreviewDefaultModel = license => ({
  ...getAlertsDefaultModel(license),
  columns: (0, _columns.getColumns)(license),
  defaultColumns: (0, _columns.getRulePreviewColumns)(license),
  sort: [{
    columnId: 'kibana.alert.original_time',
    columnType: 'date',
    esTypes: ['date'],
    sortDirection: 'desc'
  }],
  showCheckboxes: false
});
exports.getAlertsPreviewDefaultModel = getAlertsPreviewDefaultModel;
const requiredFieldsForActions = ['@timestamp', 'kibana.alert.workflow_status', 'kibana.alert.workflow_tags', 'kibana.alert.group.id', 'kibana.alert.original_time', 'kibana.alert.building_block_type', 'kibana.alert.rule.from', 'kibana.alert.rule.name', 'kibana.alert.rule.to', 'kibana.alert.rule.uuid', 'kibana.alert.rule.rule_id', 'kibana.alert.rule.type', 'kibana.alert.suppression.docs_count', 'kibana.alert.original_event.kind', 'kibana.alert.original_event.module',
// Endpoint exception fields
'file.path', 'file.Ext.code_signature.subject_name', 'file.Ext.code_signature.trusted', 'file.hash.sha256', 'host.os.family', 'event.code', 'process.entry_leader.entity_id'];
exports.requiredFieldsForActions = requiredFieldsForActions;