"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.USER_NAME_LABEL = exports.SOURCE_LABEL = exports.OTHER = exports.NON_EMPTY_FILTER = exports.HOST_NAME_LABEL = exports.EMPTY_DATA_MESSAGE = exports.DESTINATION_LABEL = exports.DATA_STATISTICS_TITLE = exports.DATA_STATISTICS_MESSAGE = exports.ALERT_BY_TITLE = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ALERT_BY_TITLE = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.alerts.alertsByGrouping.chartTitle', {
  defaultMessage: 'Top alerts by'
});
exports.ALERT_BY_TITLE = ALERT_BY_TITLE;
const EMPTY_DATA_MESSAGE = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.alerts.alertsByGrouping.noItemsFoundMessage', {
  defaultMessage: 'No items found'
});
exports.EMPTY_DATA_MESSAGE = EMPTY_DATA_MESSAGE;
const OTHER = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.alerts.alertsByGrouping.otherGroup', {
  defaultMessage: 'Other'
});
exports.OTHER = OTHER;
const HOST_NAME_LABEL = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.alerts.alertsByGrouping.hostNameLabel', {
  defaultMessage: 'host'
});
exports.HOST_NAME_LABEL = HOST_NAME_LABEL;
const USER_NAME_LABEL = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.alerts.alertsByGrouping.userNameLabel', {
  defaultMessage: 'user'
});
exports.USER_NAME_LABEL = USER_NAME_LABEL;
const DESTINATION_LABEL = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.alerts.alertsByGrouping.destinationLabel', {
  defaultMessage: 'destination'
});
exports.DESTINATION_LABEL = DESTINATION_LABEL;
const SOURCE_LABEL = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.alerts.alertsByGrouping.sourceLabel', {
  defaultMessage: 'source'
});
exports.SOURCE_LABEL = SOURCE_LABEL;
const DATA_STATISTICS_TITLE = percent => _i18n.i18n.translate('xpack.securitySolution.detectionEngine.alerts.alertsByGrouping.dataStatsTitle', {
  values: {
    percent
  },
  defaultMessage: `This field exists in {percent}% of alerts.`
});
exports.DATA_STATISTICS_TITLE = DATA_STATISTICS_TITLE;
const DATA_STATISTICS_MESSAGE = groupbySelection => _i18n.i18n.translate('xpack.securitySolution.detectionEngine.alerts.alertsByGrouping.dataStatsMessage', {
  values: {
    groupbySelection
  },
  defaultMessage: `To see alerts without {groupbySelection} you can filter in by `
});
exports.DATA_STATISTICS_MESSAGE = DATA_STATISTICS_MESSAGE;
const NON_EMPTY_FILTER = groupBySelection => _i18n.i18n.translate('xpack.securitySolution.detectionEngine.alerts.alertsByGrouping.nonEmptyFilter', {
  values: {
    groupBySelection
  },
  defaultMessage: `NOT {groupBySelection}: exists`
});
exports.NON_EMPTY_FILTER = NON_EMPTY_FILTER;