"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DETECTIONS_ALERTS_COUNT_ID = exports.AlertsCountPanel = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _uuid = require("uuid");
var _esQuery = require("@kbn/es-query");
var _use_global_time = require("../../../../common/containers/use_global_time");
var _header_section = require("../../../../common/components/header_section");
var _use_query = require("../../../containers/detection_engine/alerts/use_query");
var _constants = require("../../../containers/detection_engine/alerts/constants");
var _inspect = require("../../../../common/components/inspect");
var _helpers = require("./helpers");
var i18n = _interopRequireWildcard(require("./translations"));
var _components = require("../common/components");
var _hooks = require("../common/hooks");
var _query_toggle = require("../../../../common/containers/query_toggle");
var _field_selection = require("../../../../common/components/field_selection");
var _use_experimental_features = require("../../../../common/hooks/use_experimental_features");
var _alerts_table = require("../../../../common/components/visualization_actions/lens_attributes/common/alerts/alerts_table");
var _model = require("../../../../common/store/sourcerer/model");
var _chart_content = require("./chart_content");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DETECTIONS_ALERTS_COUNT_ID = 'detections-alerts-count';
exports.DETECTIONS_ALERTS_COUNT_ID = DETECTIONS_ALERTS_COUNT_ID;
const CHART_HEIGHT = 218; // px

const AlertsCountPanel = /*#__PURE__*/(0, _react.memo)(({
  alignHeader,
  chartOptionsContextMenu,
  extraActions,
  filters,
  inspectTitle,
  panelHeight,
  query,
  runtimeMappings,
  setStackByField0,
  setStackByField0ComboboxInputRef,
  setStackByField1,
  setStackByField1ComboboxInputRef,
  signalIndexName,
  stackByField0,
  stackByField0ComboboxRef,
  stackByField1,
  stackByField1ComboboxRef,
  stackByWidth,
  title = i18n.COUNT_TABLE_TITLE,
  isExpanded,
  setIsExpanded
}) => {
  const {
    to,
    from,
    deleteQuery,
    setQuery
  } = (0, _use_global_time.useGlobalTime)();
  const isChartEmbeddablesEnabled = (0, _use_experimental_features.useIsExperimentalFeatureEnabled)('chartEmbeddablesEnabled');
  const isAlertsPageChartsEnabled = (0, _use_experimental_features.useIsExperimentalFeatureEnabled)('alertsPageChartsEnabled');
  // create a unique, but stable (across re-renders) query id
  const uniqueQueryId = (0, _react.useMemo)(() => `${DETECTIONS_ALERTS_COUNT_ID}-${(0, _uuid.v4)()}`, []);

  // Disabling the fecth method in useQueryAlerts since it is defaulted to the old one
  // const fetchMethod = fetchQueryRuleRegistryAlerts;

  const additionalFilters = (0, _react.useMemo)(() => {
    try {
      var _filters$filter;
      return [(0, _esQuery.buildEsQuery)(undefined, query != null ? [query] : [], (_filters$filter = filters === null || filters === void 0 ? void 0 : filters.filter(f => f.meta.disabled === false)) !== null && _filters$filter !== void 0 ? _filters$filter : [])];
    } catch (e) {
      return [];
    }
  }, [query, filters]);
  const {
    toggleStatus,
    setToggleStatus
  } = (0, _query_toggle.useQueryToggle)(DETECTIONS_ALERTS_COUNT_ID);
  const toggleQuery = (0, _react.useCallback)(newToggleStatus => {
    if (isAlertsPageChartsEnabled && setIsExpanded) {
      setIsExpanded(newToggleStatus);
    } else {
      setToggleStatus(newToggleStatus);
    }
  }, [setToggleStatus, setIsExpanded, isAlertsPageChartsEnabled]);
  const querySkip = (0, _react.useMemo)(() => isAlertsPageChartsEnabled ? !isExpanded : !toggleStatus, [isAlertsPageChartsEnabled, isExpanded, toggleStatus]);
  const timerange = (0, _react.useMemo)(() => ({
    from,
    to
  }), [from, to]);
  const extraVisualizationOptions = (0, _react.useMemo)(() => ({
    breakdownField: stackByField1,
    filters
  }), [filters, stackByField1]);
  const {
    loading: isLoadingAlerts,
    data: alertsData,
    setQuery: setAlertsQuery,
    response,
    request,
    refetch
  } = (0, _use_query.useQueryAlerts)({
    query: (0, _helpers.getAlertsCountQuery)({
      stackByField0,
      stackByField1,
      from,
      to,
      additionalFilters,
      runtimeMappings
    }),
    indexName: signalIndexName,
    skip: querySkip || isChartEmbeddablesEnabled,
    queryName: _constants.ALERTS_QUERY_NAMES.COUNT
  });
  (0, _react.useEffect)(() => {
    setAlertsQuery((0, _helpers.getAlertsCountQuery)({
      additionalFilters,
      from,
      runtimeMappings,
      stackByField0,
      stackByField1,
      to
    }));
  }, [additionalFilters, from, runtimeMappings, setAlertsQuery, stackByField0, stackByField1, to]);
  (0, _hooks.useInspectButton)({
    deleteQuery,
    loading: isLoadingAlerts,
    refetch,
    request,
    response,
    setQuery,
    uniqueQueryId
  });
  const showCount = (0, _react.useMemo)(() => {
    if (isAlertsPageChartsEnabled) {
      return isExpanded;
    }
    return toggleStatus;
  }, [isAlertsPageChartsEnabled, toggleStatus, isExpanded]);
  return /*#__PURE__*/_react.default.createElement(_inspect.InspectButtonContainer, {
    show: isAlertsPageChartsEnabled ? isExpanded : toggleStatus
  }, /*#__PURE__*/_react.default.createElement(_components.KpiPanel, {
    $toggleStatus: isAlertsPageChartsEnabled && isExpanded !== undefined ? isExpanded : toggleStatus,
    "data-test-subj": "alertsCountPanel",
    hasBorder: true,
    height: panelHeight
  }, /*#__PURE__*/_react.default.createElement(_header_section.HeaderSection, {
    alignHeader: alignHeader,
    id: uniqueQueryId,
    inspectTitle: inspectTitle,
    outerDirection: "row",
    title: title,
    titleSize: "s",
    hideSubtitle: true,
    showInspectButton: chartOptionsContextMenu == null,
    toggleStatus: isAlertsPageChartsEnabled ? isExpanded : toggleStatus,
    toggleQuery: toggleQuery
  }, /*#__PURE__*/_react.default.createElement(_field_selection.FieldSelection, {
    chartOptionsContextMenu: isChartEmbeddablesEnabled ? undefined : chartOptionsContextMenu,
    setStackByField0: setStackByField0,
    setStackByField0ComboboxInputRef: setStackByField0ComboboxInputRef,
    setStackByField1: setStackByField1,
    setStackByField1ComboboxInputRef: setStackByField1ComboboxInputRef,
    stackByField0: stackByField0,
    stackByField0ComboboxRef: stackByField0ComboboxRef,
    stackByField1: stackByField1,
    stackByField1ComboboxRef: stackByField1ComboboxRef,
    stackByWidth: stackByWidth,
    uniqueQueryId: uniqueQueryId,
    useLensCompatibleFields: isChartEmbeddablesEnabled
  })), showCount && (isLoadingAlerts ? /*#__PURE__*/_react.default.createElement(_eui.EuiProgress, {
    color: "accent",
    "data-test-subj": "progress",
    position: "absolute",
    size: "xs"
  }) : /*#__PURE__*/_react.default.createElement(_chart_content.ChartContent, {
    alertsData: alertsData,
    "data-test-subj": "embeddable-count-table",
    extraActions: extraActions,
    extraOptions: extraVisualizationOptions,
    getLensAttributes: _alerts_table.getAlertsTableLensAttributes,
    height: CHART_HEIGHT,
    id: `${uniqueQueryId}-embeddable`,
    inspectTitle: inspectTitle,
    isChartEmbeddablesEnabled: isChartEmbeddablesEnabled,
    isLoadingAlerts: isLoadingAlerts,
    scopeId: _model.SourcererScopeName.detections,
    stackByField0: stackByField0,
    stackByField1: stackByField1,
    stackByField: stackByField0,
    timerange: timerange
  }))));
});
exports.AlertsCountPanel = AlertsCountPanel;
AlertsCountPanel.displayName = 'AlertsCountPanel';