"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AlertsCountComponent = exports.AlertsCount = void 0;
var _eui = require("@elastic/eui");
var _fp = require("lodash/fp");
var _react = _interopRequireWildcard(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _kibana = require("../../../../common/lib/kibana");
var _constants = require("../../../../../common/constants");
var _helpers = require("../../../../common/components/alerts_treemap/lib/helpers");
var _get_flattened_buckets = require("../../../../common/components/alerts_treemap/lib/flatten/get_flattened_buckets");
var _columns = require("./columns");
var _helpers2 = require("./helpers");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const Wrapper = _styledComponents.default.div`
  margin-top: -${({
  theme
}) => theme.eui.euiSizeS};
`;
const AlertsCountComponent = ({
  data,
  loading,
  stackByField0,
  stackByField1
}) => {
  var _data$aggregations2, _data$aggregations2$s;
  const [defaultNumberFormat] = (0, _kibana.useUiSetting$)(_constants.DEFAULT_NUMBER_FORMAT);
  const tableColumns = (0, _react.useMemo)(() => (0, _fp.isEmpty)(stackByField1 === null || stackByField1 === void 0 ? void 0 : stackByField1.trim()) ? (0, _columns.getSingleGroupByAlertsCountTableColumns)({
    defaultNumberFormat,
    stackByField0
  }) : (0, _columns.getMultiGroupAlertsCountTableColumns)({
    defaultNumberFormat,
    stackByField0,
    stackByField1
  }), [defaultNumberFormat, stackByField0, stackByField1]);
  const buckets = (0, _react.useMemo)(() => {
    var _data$aggregations, _data$aggregations$st;
    return (0, _helpers.getUpToMaxBuckets)({
      buckets: (_data$aggregations = data.aggregations) === null || _data$aggregations === void 0 ? void 0 : (_data$aggregations$st = _data$aggregations.stackByField0) === null || _data$aggregations$st === void 0 ? void 0 : _data$aggregations$st.buckets,
      maxItems: _helpers2.DEFAULT_STACK_BY_FIELD0_SIZE
    });
  }, [(_data$aggregations2 = data.aggregations) === null || _data$aggregations2 === void 0 ? void 0 : (_data$aggregations2$s = _data$aggregations2.stackByField0) === null || _data$aggregations2$s === void 0 ? void 0 : _data$aggregations2$s.buckets]);
  const maxRiskSubAggregations = (0, _react.useMemo)(() => (0, _helpers.getMaxRiskSubAggregations)(buckets), [buckets]);
  const items = (0, _react.useMemo)(() => (0, _fp.isEmpty)(stackByField1 === null || stackByField1 === void 0 ? void 0 : stackByField1.trim()) ? buckets : (0, _get_flattened_buckets.getFlattenedBuckets)({
    buckets,
    maxRiskSubAggregations,
    stackByField0
  }), [buckets, maxRiskSubAggregations, stackByField0, stackByField1]);
  return /*#__PURE__*/_react.default.createElement(Wrapper, {
    "data-test-subj": "alertsCountTable",
    className: "eui-yScroll"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiInMemoryTable, {
    isSelectable: false,
    columns: tableColumns,
    items: items,
    loading: loading,
    sorting: true
  }));
};
exports.AlertsCountComponent = AlertsCountComponent;
AlertsCountComponent.displayName = 'AlertsCountComponent';
const AlertsCount = /*#__PURE__*/_react.default.memo(AlertsCountComponent);
exports.AlertsCount = AlertsCount;