"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ResponseActionsList = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _reactRouterDom = require("react-router-dom");
var _osquery_investigation_guide_panel = require("./osquery/osquery_investigation_guide_panel");
var _logic = require("../rule_management/logic");
var _response_action_type_form = require("./response_action_type_form");
var _shared_imports = require("../../shared_imports");
var _utils = require("./utils");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const GhostFormField = () => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null);
const ResponseActionsList = /*#__PURE__*/_react.default.memo(({
  items,
  removeItem
}) => {
  const {
    detailName: ruleId
  } = (0, _reactRouterDom.useParams)();
  const {
    data: rule
  } = (0, _logic.useRule)(ruleId);
  const osqueryNoteQueries = (0, _react.useMemo)(() => rule !== null && rule !== void 0 && rule.note ? (0, _utils.getOsqueryQueriesFromNote)(rule.note) : [], [rule === null || rule === void 0 ? void 0 : rule.note]);
  const context = (0, _shared_imports.useFormContext)();
  const [formData] = (0, _shared_imports.useFormData)();
  const handleInvestigationGuideClick = (0, _react.useCallback)(() => {
    const values = (0, _utils.getResponseActionsFromNote)(osqueryNoteQueries, formData.responseActions);
    context.updateFieldValues(values);
  }, [context, formData === null || formData === void 0 ? void 0 : formData.responseActions, osqueryNoteQueries]);
  return /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": 'response-actions-list'
  }, items.map((actionItem, index) => {
    return /*#__PURE__*/_react.default.createElement("div", {
      key: actionItem.id,
      "data-test-subj": `response-actions-list-item-${index}`
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m"
    }), /*#__PURE__*/_react.default.createElement(_response_action_type_form.ResponseActionTypeForm, {
      item: actionItem,
      onDeleteAction: removeItem
    }), /*#__PURE__*/_react.default.createElement(_shared_imports.UseField, {
      path: `${actionItem.path}.actionTypeId`,
      component: GhostFormField
    }));
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), osqueryNoteQueries.length ? /*#__PURE__*/_react.default.createElement(_osquery_investigation_guide_panel.OsqueryInvestigationGuidePanel, {
    onClick: handleInvestigationGuideClick,
    queriesLength: osqueryNoteQueries.length
  }) : null);
});
exports.ResponseActionsList = ResponseActionsList;
ResponseActionsList.displayName = 'ResponseActionsList';