"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EndpointResponseAction = void 0;
var _react = _interopRequireDefault(require("react"));
var _comment_field = require("./comment_field");
var _action_type_field = require("./action_type_field");
var _callout = require("./callout");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const EndpointResponseAction = /*#__PURE__*/_react.default.memo(props => {
  const paramsPath = `${props.item.path}.params`;
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_action_type_field.ActionTypeField, {
    basePath: paramsPath,
    disabled: props.editDisabled,
    readDefaultValueOnForm: !props.item.isNew
  }), /*#__PURE__*/_react.default.createElement(_callout.EndpointActionCallout, {
    basePath: paramsPath,
    editDisabled: props.editDisabled
  }), /*#__PURE__*/_react.default.createElement(_comment_field.CommentField, {
    basePath: paramsPath,
    disabled: props.editDisabled,
    readDefaultValueOnForm: !props.item.isNew
  }));
});
exports.EndpointResponseAction = EndpointResponseAction;
EndpointResponseAction.displayName = 'EndpointResponseAction';