"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useFilterPrebuiltRulesToUpgrade = void 0;
var _react = require("react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useFilterPrebuiltRulesToUpgrade = ({
  rules,
  filterOptions
}) => {
  const filteredRules = (0, _react.useMemo)(() => {
    const {
      filter,
      tags
    } = filterOptions;
    return rules.filter(({
      rule
    }) => {
      if (filter && !rule.name.toLowerCase().includes(filter.toLowerCase())) {
        return false;
      }
      if (tags && tags.length > 0) {
        return tags.every(tag => rule.tags.includes(tag));
      }
      return true;
    });
  }, [filterOptions, rules]);
  return filteredRules;
};
exports.useFilterPrebuiltRulesToUpgrade = useFilterPrebuiltRulesToUpgrade;