"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UpgradePrebuiltRulesTableButtons = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _user_info = require("../../../../../detections/components/user_info");
var i18n = _interopRequireWildcard(require("./translations"));
var _upgrade_prebuilt_rules_table_context = require("./upgrade_prebuilt_rules_table_context");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const UpgradePrebuiltRulesTableButtons = () => {
  var _selectedRules$length;
  const {
    state: {
      rules,
      selectedRules,
      loadingRules,
      isRefetching,
      isUpgradingSecurityPackages
    },
    actions: {
      upgradeAllRules,
      upgradeSelectedRules
    }
  } = (0, _upgrade_prebuilt_rules_table_context.useUpgradePrebuiltRulesTableContext)();
  const [{
    loading: isUserDataLoading,
    canUserCRUD
  }] = (0, _user_info.useUserData)();
  const canUserEditRules = canUserCRUD && !isUserDataLoading;
  const isRulesAvailableForUpgrade = rules.length > 0;
  const numberOfSelectedRules = (_selectedRules$length = selectedRules.length) !== null && _selectedRules$length !== void 0 ? _selectedRules$length : 0;
  const shouldDisplayUpgradeSelectedRulesButton = numberOfSelectedRules > 0;
  const isRuleUpgrading = loadingRules.length > 0;
  const isRequestInProgress = isRuleUpgrading || isRefetching || isUpgradingSecurityPackages;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "s",
    responsive: false,
    wrap: true
  }, shouldDisplayUpgradeSelectedRulesButton ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    onClick: upgradeSelectedRules,
    disabled: !canUserEditRules || isRequestInProgress,
    "data-test-subj": "upgradeSelectedRulesButton"
  }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, i18n.UPDATE_SELECTED_RULES(numberOfSelectedRules), isRuleUpgrading ? /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
    size: "s"
  }) : undefined))) : null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    fill: true,
    iconType: "plusInCircle",
    onClick: upgradeAllRules,
    disabled: !canUserEditRules || !isRulesAvailableForUpgrade || isRequestInProgress,
    "data-test-subj": "upgradeAllRulesButton"
  }, i18n.UPDATE_ALL, isRuleUpgrading ? /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
    size: "s"
  }) : undefined)));
};
exports.UpgradePrebuiltRulesTableButtons = UpgradePrebuiltRulesTableButtons;