"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TableHeaderTooltipCell = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Table header cell component that includes icon(question mark) tooltip with additional details about column
 * Icon tooltip will never be truncated and always be visible for user interaction
 * @param title string - column header title
 * @param tooltipContent string - text content of tooltip
 * @param customTooltip React.ReactNode - any custom tooltip
 */
const TableHeaderTooltipCellComponent = ({
  title,
  tooltipContent,
  customTooltip
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
  gutterSize: "none"
}, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  style: {
    width: 'calc(100% - 20px)'
  }
}, /*#__PURE__*/_react.default.createElement("span", {
  className: "eui-textTruncate"
}, title)), customTooltip !== null && customTooltip !== void 0 ? customTooltip : /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
  content: tooltipContent
}, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
  "data-test-subj": "tableHeaderIcon",
  size: "m",
  color: "subdued",
  type: "questionInCircle",
  style: {
    marginLeft: 4
  }
})));
const TableHeaderTooltipCell = /*#__PURE__*/_react.default.memo(TableHeaderTooltipCellComponent);
exports.TableHeaderTooltipCell = TableHeaderTooltipCell;
TableHeaderTooltipCell.displayName = 'TableHeaderTooltipCell';