"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TimelineTemplateForm = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _shared_imports = require("../../../../../../shared_imports");
var _pick_timeline = require("../../../../../../detections/components/rules/pick_timeline");
var _request_schema = require("../../../../../../../common/detection_engine/rule_management/api/rules/bulk_actions/request_schema");
var _bulk_edit_form_wrapper = require("./bulk_edit_form_wrapper");
var _translations = require("../translations");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const formSchema = {
  timeline: {
    label: _translations.bulkApplyTimelineTemplate.TEMPLATE_SELECTOR_LABEL,
    helpText: _translations.bulkApplyTimelineTemplate.TEMPLATE_SELECTOR_HELP_TEXT
  }
};
const defaultFormData = {
  timeline: {
    id: null,
    title: _translations.bulkApplyTimelineTemplate.TEMPLATE_SELECTOR_DEFAULT_VALUE
  }
};
const TimelineTemplateFormComponent = props => {
  const {
    rulesCount,
    onClose,
    onConfirm
  } = props;
  const {
    form
  } = (0, _shared_imports.useForm)({
    schema: formSchema,
    defaultValue: defaultFormData
  });
  const handleSubmit = (0, _react.useCallback)(async () => {
    const {
      data,
      isValid
    } = await form.submit();
    if (!isValid) {
      return;
    }
    const timelineId = data.timeline.id || '';
    const timelineTitle = timelineId ? data.timeline.title : '';
    onConfirm({
      type: _request_schema.BulkActionEditType.set_timeline,
      value: {
        timeline_id: timelineId,
        timeline_title: timelineTitle
      }
    });
  }, [form, onConfirm]);
  const warningCallout = /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    color: "warning",
    "data-test-subj": "bulkEditRulesTimelineTemplateWarning"
  }, _translations.bulkApplyTimelineTemplate.warningCalloutMessage(rulesCount));
  return /*#__PURE__*/_react.default.createElement(_bulk_edit_form_wrapper.BulkEditFormWrapper, {
    form: form,
    title: _translations.bulkApplyTimelineTemplate.FORM_TITLE,
    banner: warningCallout,
    onClose: onClose,
    onSubmit: handleSubmit
  }, /*#__PURE__*/_react.default.createElement(_shared_imports.UseField, {
    path: "timeline",
    component: _pick_timeline.PickTimeline,
    componentProps: {
      idAria: 'bulkEditRulesTimelineTemplateSelector',
      dataTestSubj: 'bulkEditRulesTimelineTemplateSelector',
      placeholder: _translations.bulkApplyTimelineTemplate.TEMPLATE_SELECTOR_PLACEHOLDER
    }
  }));
};
const TimelineTemplateForm = /*#__PURE__*/_react.default.memo(TimelineTemplateFormComponent);
exports.TimelineTemplateForm = TimelineTemplateForm;
TimelineTemplateForm.displayName = 'TimelineTemplateForm';