"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MaintenanceWindowCallout = MaintenanceWindowCallout;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _common = require("@kbn/alerting-plugin/common");
var _use_fetch_active_maintenance_windows = require("./use_fetch_active_maintenance_windows");
var i18n = _interopRequireWildcard(require("./translations"));
var _kibana = require("../../../../common/lib/kibana");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function MaintenanceWindowCallout() {
  const {
    application: {
      capabilities
    }
  } = (0, _kibana.useKibana)().services;
  const isMaintenanceWindowDisabled = !capabilities[_common.MAINTENANCE_WINDOW_FEATURE_ID].show && !capabilities[_common.MAINTENANCE_WINDOW_FEATURE_ID].save;
  const {
    data
  } = (0, _use_fetch_active_maintenance_windows.useFetchActiveMaintenanceWindows)({
    enabled: !isMaintenanceWindowDisabled
  });
  if (isMaintenanceWindowDisabled) {
    return null;
  }
  const activeMaintenanceWindows = data || [];
  if (activeMaintenanceWindows.some(({
    status
  }) => status === _common.MaintenanceWindowStatus.Running)) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
      title: i18n.MAINTENANCE_WINDOW_RUNNING,
      color: "warning",
      iconType: "iInCircle"
    }, i18n.MAINTENANCE_WINDOW_RUNNING_DESCRIPTION);
  }
  return null;
}