"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useFetchConnectors = exports.useFetchConnectorTypes = void 0;
var _reactQuery = require("@tanstack/react-query");
var _common = require("@kbn/actions-plugin/common");
var _use_app_toasts = require("../../../../common/hooks/use_app_toasts");
var _api = require("../api");
var i18n = _interopRequireWildcard(require("./translations"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useFetchConnectors = () => {
  const {
    addError
  } = (0, _use_app_toasts.useAppToasts)();
  return (0, _reactQuery.useQuery)(['GET', _common.BASE_ACTION_API_PATH, 'connectors'], ({
    signal
  }) => (0, _api.fetchConnectors)(signal), {
    onError: error => {
      addError(error, {
        title: i18n.CONNECTORS_FETCH_ERROR,
        toastMessage: i18n.ACTIONS_FETCH_ERROR_DESCRIPTION
      });
    }
  });
};
exports.useFetchConnectors = useFetchConnectors;
const useFetchConnectorTypes = () => {
  const {
    addError
  } = (0, _use_app_toasts.useAppToasts)();
  return (0, _reactQuery.useQuery)(['GET', _common.BASE_ACTION_API_PATH, 'connector_types', 'siem'], ({
    signal
  }) => (0, _api.fetchConnectorTypes)(signal), {
    onError: error => {
      addError(error, {
        title: i18n.CONNECTOR_TYPES_FETCH_ERROR,
        toastMessage: i18n.ACTIONS_FETCH_ERROR_DESCRIPTION
      });
    }
  });
};
exports.useFetchConnectorTypes = useFetchConnectorTypes;