"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useBulkExportMutation = exports.BULK_ACTION_MUTATION_KEY = void 0;
var _reactQuery = require("@tanstack/react-query");
var _constants = require("../../../../../common/constants");
var _api = require("../api");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const BULK_ACTION_MUTATION_KEY = ['POST', _constants.DETECTION_ENGINE_RULES_BULK_ACTION];
exports.BULK_ACTION_MUTATION_KEY = BULK_ACTION_MUTATION_KEY;
const useBulkExportMutation = options => {
  return (0, _reactQuery.useMutation)(action => (0, _api.bulkExportRules)(action), {
    ...options,
    mutationKey: BULK_ACTION_MUTATION_KEY
  });
};
exports.useBulkExportMutation = useBulkExportMutation;