"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useBulkActionMutation = exports.BULK_ACTION_MUTATION_KEY = void 0;
var _reactQuery = require("@tanstack/react-query");
var _request_schema = require("../../../../../common/detection_engine/rule_management/api/rules/bulk_actions/request_schema");
var _api = require("../api");
var _constants = require("../../../../../common/constants");
var _use_find_rules_query = require("./use_find_rules_query");
var _use_fetch_rule_by_id_query = require("./use_fetch_rule_by_id_query");
var _use_fetch_rule_management_filters_query = require("./use_fetch_rule_management_filters_query");
var _use_fetch_prebuilt_rules_status_query = require("./prebuilt_rules/use_fetch_prebuilt_rules_status_query");
var _use_fetch_prebuilt_rules_upgrade_review_query = require("./prebuilt_rules/use_fetch_prebuilt_rules_upgrade_review_query");
var _use_fetch_prebuilt_rules_install_review_query = require("./prebuilt_rules/use_fetch_prebuilt_rules_install_review_query");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const BULK_ACTION_MUTATION_KEY = ['POST', _constants.DETECTION_ENGINE_RULES_BULK_ACTION];
exports.BULK_ACTION_MUTATION_KEY = BULK_ACTION_MUTATION_KEY;
const useBulkActionMutation = options => {
  const invalidateFindRulesQuery = (0, _use_find_rules_query.useInvalidateFindRulesQuery)();
  const invalidateFetchRuleByIdQuery = (0, _use_fetch_rule_by_id_query.useInvalidateFetchRuleByIdQuery)();
  const invalidateFetchRuleManagementFilters = (0, _use_fetch_rule_management_filters_query.useInvalidateFetchRuleManagementFiltersQuery)();
  const invalidateFetchPrebuiltRulesStatusQuery = (0, _use_fetch_prebuilt_rules_status_query.useInvalidateFetchPrebuiltRulesStatusQuery)();
  const invalidateFetchPrebuiltRulesInstallReviewQuery = (0, _use_fetch_prebuilt_rules_install_review_query.useInvalidateFetchPrebuiltRulesInstallReviewQuery)();
  const invalidateFetchPrebuiltRulesUpgradeReviewQuery = (0, _use_fetch_prebuilt_rules_upgrade_review_query.useInvalidateFetchPrebuiltRulesUpgradeReviewQuery)();
  const updateRulesCache = (0, _use_find_rules_query.useUpdateRulesCache)();
  return (0, _reactQuery.useMutation)(bulkActionProps => (0, _api.performBulkAction)(bulkActionProps), {
    ...options,
    mutationKey: BULK_ACTION_MUTATION_KEY,
    onSettled: (...args) => {
      var _response$attributes$, _response$attributes, _response$attributes$2, _error$body, _error$body$attribute, _error$body$attribute2;
      const [response, error, {
        bulkAction: {
          type: actionType
        }
      }] = args;
      const updatedRules = (_response$attributes$ = response === null || response === void 0 ? void 0 : (_response$attributes = response.attributes) === null || _response$attributes === void 0 ? void 0 : (_response$attributes$2 = _response$attributes.results) === null || _response$attributes$2 === void 0 ? void 0 : _response$attributes$2.updated) !== null && _response$attributes$ !== void 0 ? _response$attributes$ : error === null || error === void 0 ? void 0 : (_error$body = error.body) === null || _error$body === void 0 ? void 0 : (_error$body$attribute = _error$body.attributes) === null || _error$body$attribute === void 0 ? void 0 : (_error$body$attribute2 = _error$body$attribute.results) === null || _error$body$attribute2 === void 0 ? void 0 : _error$body$attribute2.updated;
      switch (actionType) {
        case _request_schema.BulkActionType.enable:
        case _request_schema.BulkActionType.disable:
          {
            invalidateFetchRuleByIdQuery();
            if (updatedRules) {
              // We have a list of updated rules, no need to invalidate all
              updateRulesCache(updatedRules);
            } else {
              // We failed to receive the list of update rules, invalidate all
              invalidateFindRulesQuery();
            }
            break;
          }
        case _request_schema.BulkActionType.delete:
          invalidateFindRulesQuery();
          invalidateFetchRuleByIdQuery();
          invalidateFetchRuleManagementFilters();
          invalidateFetchPrebuiltRulesStatusQuery();
          invalidateFetchPrebuiltRulesInstallReviewQuery();
          invalidateFetchPrebuiltRulesUpgradeReviewQuery();
          break;
        case _request_schema.BulkActionType.duplicate:
          invalidateFindRulesQuery();
          invalidateFetchRuleManagementFilters();
          break;
        case _request_schema.BulkActionType.edit:
          if (updatedRules) {
            // We have a list of updated rules, no need to invalidate all
            updateRulesCache(updatedRules);
          } else {
            // We failed to receive the list of update rules, invalidate all
            invalidateFindRulesQuery();
          }
          invalidateFetchRuleByIdQuery();
          invalidateFetchRuleManagementFilters();
          break;
      }
      if (options !== null && options !== void 0 && options.onSettled) {
        options.onSettled(...args);
      }
    }
  });
};
exports.useBulkActionMutation = useBulkActionMutation;