"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useCreateOrUpdateException = void 0;
var _react = require("react");
var _securitysolutionListHooks = require("@kbn/securitysolution-list-hooks");
var _helpers = require("../utils/helpers");
var _kibana = require("../../../common/lib/kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Hook for adding and/or updating an exception item
 */
const useCreateOrUpdateException = () => {
  const {
    services: {
      http
    }
  } = (0, _kibana.useKibana)();
  const [isLoading, setIsLoading] = (0, _react.useState)(false);
  const addOrUpdateExceptionRef = (0, _react.useRef)(null);
  const {
    addExceptionListItem,
    updateExceptionListItem
  } = (0, _securitysolutionListHooks.useApi)(http);
  (0, _react.useEffect)(() => {
    const abortCtrl = new AbortController();
    const onCreateOrUpdateExceptionItem = async items => {
      setIsLoading(true);
      const itemsAdded = await Promise.all(items.map(item => {
        if ('id' in item && item.id != null) {
          const formattedExceptionItem = (0, _helpers.formatExceptionItemForUpdate)(item);
          return updateExceptionListItem({
            listItem: formattedExceptionItem
          });
        } else {
          return addExceptionListItem({
            listItem: item
          });
        }
      }));
      setIsLoading(false);
      return itemsAdded;
    };
    addOrUpdateExceptionRef.current = onCreateOrUpdateExceptionItem;
    return () => {
      setIsLoading(false);
      abortCtrl.abort();
    };
  }, [updateExceptionListItem, http, addExceptionListItem]);
  return [isLoading, addOrUpdateExceptionRef.current];
};
exports.useCreateOrUpdateException = useCreateOrUpdateException;