"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ErrorCallout = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var i18n = _interopRequireWildcard(require("../../utils/translations"));
var _use_disassociate_exception_list = require("../../../rule_management/logic/use_disassociate_exception_list");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ErrorCalloutComponent = ({
  http,
  rule,
  errorInfo,
  onCancel,
  onError,
  onSuccess
}) => {
  const [listToDelete, setListToDelete] = (0, _react.useState)(null);
  const [errorTitle, setErrorTitle] = (0, _react.useState)('');
  const [errorMessage, setErrorMessage] = (0, _react.useState)(i18n.ADD_EXCEPTION_FETCH_ERROR);
  const handleOnSuccess = (0, _react.useCallback)(() => {
    onSuccess(listToDelete != null ? listToDelete.id : '');
  }, [onSuccess, listToDelete]);
  const [isDisassociatingList, handleDisassociateExceptionList] = (0, _use_disassociate_exception_list.useDisassociateExceptionList)({
    http,
    ruleRuleId: rule != null ? rule.rule_id : '',
    onSuccess: handleOnSuccess,
    onError
  });
  const canDisplay404Actions = (0, _react.useMemo)(() => errorInfo.code === 404 && rule != null && listToDelete != null && handleDisassociateExceptionList != null, [errorInfo.code, listToDelete, handleDisassociateExceptionList, rule]);
  (0, _react.useEffect)(() => {
    // Yes, it's redundant, unfortunately typescript wasn't picking up
    // that `listToDelete` is checked in canDisplay404Actions
    if (canDisplay404Actions && listToDelete != null) {
      setErrorMessage(i18n.ADD_EXCEPTION_FETCH_404_ERROR(listToDelete.id));
    }
    setErrorTitle(`${errorInfo.reason}${errorInfo.code != null ? ` (${errorInfo.code})` : ''}`);
  }, [errorInfo.reason, errorInfo.code, listToDelete, canDisplay404Actions]);
  const handleDisassociateList = (0, _react.useCallback)(() => {
    // Yes, it's redundant, unfortunately typescript wasn't picking up
    // that `handleDisassociateExceptionList` and `list` are checked in
    // canDisplay404Actions
    if (canDisplay404Actions && rule != null && listToDelete != null && handleDisassociateExceptionList != null) {
      var _rule$exceptions_list;
      const exceptionLists = ((_rule$exceptions_list = rule.exceptions_list) !== null && _rule$exceptions_list !== void 0 ? _rule$exceptions_list : []).filter(({
        id
      }) => id !== listToDelete.id);
      handleDisassociateExceptionList(exceptionLists);
    }
  }, [handleDisassociateExceptionList, listToDelete, canDisplay404Actions, rule]);
  (0, _react.useEffect)(() => {
    if (errorInfo.code === 404 && rule != null && rule.exceptions_list != null) {
      const [listFound] = rule.exceptions_list.filter(({
        id,
        list_id: listId
      }) => errorInfo.details != null && errorInfo.details.includes(id) || errorInfo.listListId === listId);
      setListToDelete(listFound);
    }
  }, [rule, errorInfo.details, errorInfo.code, errorInfo.listListId]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    "data-test-subj": "errorCalloutContainer",
    title: `${i18n.ERROR}: ${errorTitle}`,
    color: "danger",
    iconType: "warning"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("p", {
    "data-test-subj": "errorCalloutMessage"
  }, errorMessage)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), listToDelete != null && /*#__PURE__*/_react.default.createElement(_eui.EuiAccordion, {
    id: "accordion1",
    buttonContent: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s"
    }, /*#__PURE__*/_react.default.createElement("p", null, i18n.MODAL_ERROR_ACCORDION_TEXT))
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
    language: "json",
    fontSize: "s",
    paddingSize: "m",
    overflowHeight: 300,
    isCopyable: true
  }, JSON.stringify(listToDelete))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "errorCalloutCancelButton",
    color: "danger",
    isDisabled: isDisassociatingList,
    onClick: onCancel
  }, i18n.CANCEL), canDisplay404Actions && /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "errorCalloutDisassociateButton",
    isLoading: isDisassociatingList,
    onClick: handleDisassociateList,
    color: "danger"
  }, i18n.CLEAR_EXCEPTIONS_LABEL));
};
ErrorCalloutComponent.displayName = 'ErrorCalloutComponent';
const ErrorCallout = /*#__PURE__*/_react.default.memo(ErrorCalloutComponent);
exports.ErrorCallout = ErrorCallout;
ErrorCallout.displayName = 'ErrorCallout';