"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EditRulePage = void 0;
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _react = _interopRequireWildcard(require("react"));
var _reactRouterDom = require("react-router-dom");
var _lodash = require("lodash");
var _rule_preview = require("../../../../detections/components/rules/rule_preview");
var _helpers = require("../../../../detections/components/rules/rule_preview/helpers");
var _logic = require("../../../rule_management/logic");
var _use_lists_config = require("../../../../detections/containers/detection_engine/lists/use_lists_config");
var _page_wrapper = require("../../../../common/components/page_wrapper");
var _privileges = require("../../../../common/utils/privileges");
var _redirect_to_detection_engine = require("../../../../common/components/link_to/redirect_to_detection_engine");
var _toasters = require("../../../../common/components/toasters");
var _spy_routes = require("../../../../common/utils/route/spy_routes");
var _user_info = require("../../../../detections/components/user_info");
var _step_panel = require("../../../../detections/components/rules/step_panel");
var _step_about_rule = require("../../../../detections/components/rules/step_about_rule");
var _step_define_rule = require("../../../../detections/components/rules/step_define_rule");
var _step_schedule_rule = require("../../../../detections/components/rules/step_schedule_rule");
var _step_rule_actions = require("../../../../detections/components/rules/step_rule_actions");
var _helpers2 = require("../rule_creation/helpers");
var _helpers3 = require("../../../../detections/pages/detection_engine/rules/helpers");
var ruleI18n = _interopRequireWildcard(require("../../../../detections/pages/detection_engine/rules/translations"));
var _types = require("../../../../detections/pages/detection_engine/rules/types");
var i18n = _interopRequireWildcard(require("./translations"));
var _types2 = require("../../../../app/types");
var _utils = require("../../../../detections/pages/detection_engine/rules/utils");
var _kibana = require("../../../../common/lib/kibana");
var _constants = require("../../../../../common/constants");
var _use_start_transaction = require("../../../../common/lib/apm/use_start_transaction");
var _user_actions = require("../../../../common/lib/apm/user_actions");
var _use_get_saved_query = require("../../../../detections/pages/detection_engine/rules/use_get_saved_query");
var _form = require("../form");
var _ = require("..");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const EditRulePageComponent = ({
  rule
}) => {
  const [, dispatchToaster] = (0, _toasters.useStateToaster)();
  const [{
    loading: userInfoLoading,
    isSignalIndexExists,
    isAuthenticated,
    hasEncryptionKey,
    canUserCRUD
  }] = (0, _user_info.useUserData)();
  const {
    loading: listsConfigLoading,
    needsConfiguration: needsListsConfiguration
  } = (0, _use_lists_config.useListsConfig)();
  const {
    data: dataServices,
    application
  } = (0, _kibana.useKibana)().services;
  const {
    navigateToApp
  } = application;
  const {
    detailName: ruleId
  } = (0, _reactRouterDom.useParams)();
  const [activeStep, setActiveStep] = (0, _react.useState)(rule.immutable ? _types.RuleStep.ruleActions : _types.RuleStep.defineRule);
  const {
    mutateAsync: updateRule,
    isLoading
  } = (0, _logic.useUpdateRule)();
  const [dataViewOptions, setDataViewOptions] = (0, _react.useState)({});
  const [isRulePreviewVisible, setIsRulePreviewVisible] = (0, _react.useState)(true);
  const collapseFn = (0, _react.useRef)();
  const [isQueryBarValid, setIsQueryBarValid] = (0, _react.useState)(false);
  const [isThreatQueryBarValid, setIsThreatQueryBarValid] = (0, _react.useState)(false);
  (0, _react.useEffect)(() => {
    const fetchDataViews = async () => {
      const dataViewsRefs = await dataServices.dataViews.getIdsWithTitle();
      const dataViewIdIndexPatternMap = dataViewsRefs.reduce((acc, item) => ({
        ...acc,
        [item.id]: item
      }), {});
      setDataViewOptions(dataViewIdIndexPatternMap);
    };
    fetchDataViews();
  }, [dataServices.dataViews]);
  const backOptions = (0, _react.useMemo)(() => {
    var _rule$name;
    return {
      path: (0, _redirect_to_detection_engine.getRuleDetailsUrl)(ruleId !== null && ruleId !== void 0 ? ruleId : ''),
      text: `${i18n.BACK_TO} ${(_rule$name = rule === null || rule === void 0 ? void 0 : rule.name) !== null && _rule$name !== void 0 ? _rule$name : ''}`,
      pageId: _types2.SecurityPageName.rules,
      dataTestSubj: 'ruleEditBackToRuleDetails'
    };
  }, [rule === null || rule === void 0 ? void 0 : rule.name, ruleId]);
  const [indicesConfig] = (0, _kibana.useUiSetting$)(_constants.DEFAULT_INDEX_KEY);
  const [threatIndicesConfig] = (0, _kibana.useUiSetting$)(_constants.DEFAULT_THREAT_INDEX_KEY);
  const {
    aboutRuleData,
    defineRuleData,
    scheduleRuleData,
    ruleActionsData
  } = (0, _helpers3.getStepsData)({
    rule
  });
  const {
    defineStepForm,
    defineStepData,
    aboutStepForm,
    aboutStepData,
    scheduleStepForm,
    scheduleStepData,
    actionsStepForm,
    actionsStepData,
    eqlOptionsSelected,
    setEqlOptionsSelected
  } = (0, _form.useRuleForms)({
    defineStepDefault: defineRuleData,
    aboutStepDefault: aboutRuleData,
    scheduleStepDefault: scheduleRuleData,
    actionsStepDefault: ruleActionsData
  });
  const isPreviewDisabled = (0, _helpers.getIsRulePreviewDisabled)({
    ruleType: defineStepData.ruleType,
    isQueryBarValid,
    isThreatQueryBarValid,
    index: defineStepData.index,
    dataViewId: defineStepData.dataViewId,
    dataSourceType: defineStepData.dataSourceType,
    threatIndex: defineStepData.threatIndex,
    threatMapping: defineStepData.threatMapping,
    machineLearningJobId: defineStepData.machineLearningJobId,
    queryBar: defineStepData.queryBar,
    newTermsFields: defineStepData.newTermsFields
  });
  const loading = userInfoLoading || listsConfigLoading;
  const {
    isSavedQueryLoading,
    savedQuery
  } = (0, _use_get_saved_query.useGetSavedQuery)({
    savedQueryId: rule === null || rule === void 0 ? void 0 : rule.saved_id,
    ruleType: rule === null || rule === void 0 ? void 0 : rule.type,
    onError: _lodash.noop
  });

  // Since in the edit step we start with an existing rule, we assume that
  // the steps are valid if isValid is undefined. Once the user triggers validation by
  // trying to submit the edits, the isValid statuses will be tracked and the callout appears
  // if some steps are invalid
  const stepIsValid = (0, _react.useCallback)(step => {
    var _defineStepForm$isVal, _aboutStepForm$isVali, _scheduleStepForm$isV, _actionsStepForm$isVa;
    switch (step) {
      case _types.RuleStep.defineRule:
        return (_defineStepForm$isVal = defineStepForm.isValid) !== null && _defineStepForm$isVal !== void 0 ? _defineStepForm$isVal : true;
      case _types.RuleStep.aboutRule:
        return (_aboutStepForm$isVali = aboutStepForm.isValid) !== null && _aboutStepForm$isVali !== void 0 ? _aboutStepForm$isVali : true;
      case _types.RuleStep.scheduleRule:
        return (_scheduleStepForm$isV = scheduleStepForm.isValid) !== null && _scheduleStepForm$isV !== void 0 ? _scheduleStepForm$isV : true;
      case _types.RuleStep.ruleActions:
        return (_actionsStepForm$isVa = actionsStepForm.isValid) !== null && _actionsStepForm$isVa !== void 0 ? _actionsStepForm$isVa : true;
      default:
        return true;
    }
  }, [aboutStepForm.isValid, actionsStepForm.isValid, defineStepForm.isValid, scheduleStepForm.isValid]);
  const invalidSteps = _utils.ruleStepsOrder.filter(step => {
    return !stepIsValid(step);
  });
  const actionMessageParams = (0, _react.useMemo)(() => (0, _helpers3.getActionMessageParams)(rule === null || rule === void 0 ? void 0 : rule.type), [rule === null || rule === void 0 ? void 0 : rule.type]);
  const {
    indexPattern,
    isIndexPatternLoading,
    browserFields
  } = (0, _form.useRuleIndexPattern)({
    dataSourceType: defineStepData.dataSourceType,
    index: defineStepData.index,
    dataViewId: defineStepData.dataViewId
  });
  const tabs = (0, _react.useMemo)(() => [{
    'data-test-subj': 'edit-rule-define-tab',
    id: _types.RuleStep.defineRule,
    name: ruleI18n.DEFINITION,
    disabled: rule === null || rule === void 0 ? void 0 : rule.immutable,
    content: /*#__PURE__*/_react.default.createElement("div", {
      style: {
        display: activeStep === _types.RuleStep.defineRule ? undefined : 'none'
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_step_panel.StepPanel, {
      loading: loading || isSavedQueryLoading,
      title: ruleI18n.DEFINITION
    }, !isSavedQueryLoading && /*#__PURE__*/_react.default.createElement(_step_define_rule.StepDefineRule, {
      isLoading: loading || isLoading || isSavedQueryLoading,
      isUpdateView: true,
      kibanaDataViews: dataViewOptions,
      indicesConfig: indicesConfig,
      threatIndicesConfig: threatIndicesConfig,
      defaultSavedQuery: savedQuery,
      form: defineStepForm,
      optionsSelected: eqlOptionsSelected,
      setOptionsSelected: setEqlOptionsSelected,
      key: "defineStep",
      indexPattern: indexPattern,
      isIndexPatternLoading: isIndexPatternLoading,
      browserFields: browserFields,
      isQueryBarValid: isQueryBarValid,
      setIsQueryBarValid: setIsQueryBarValid,
      setIsThreatQueryBarValid: setIsThreatQueryBarValid,
      ruleType: defineStepData.ruleType,
      index: defineStepData.index,
      threatIndex: defineStepData.threatIndex,
      groupByFields: defineStepData.groupByFields,
      dataSourceType: defineStepData.dataSourceType,
      shouldLoadQueryDynamically: defineStepData.shouldLoadQueryDynamically,
      queryBarTitle: defineStepData.queryBar.title,
      queryBarSavedId: defineStepData.queryBar.saved_id
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null)))
  }, {
    'data-test-subj': 'edit-rule-about-tab',
    id: _types.RuleStep.aboutRule,
    name: ruleI18n.ABOUT,
    disabled: rule === null || rule === void 0 ? void 0 : rule.immutable,
    content: /*#__PURE__*/_react.default.createElement("div", {
      style: {
        display: activeStep === _types.RuleStep.aboutRule ? undefined : 'none'
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_step_panel.StepPanel, {
      loading: loading,
      title: ruleI18n.ABOUT
    }, aboutStepData != null && defineStepData != null && /*#__PURE__*/_react.default.createElement(_step_about_rule.StepAboutRule, {
      isLoading: isLoading,
      isUpdateView: true,
      isActive: activeStep === _types.RuleStep.aboutRule,
      ruleType: defineStepData.ruleType,
      machineLearningJobId: defineStepData.machineLearningJobId,
      index: defineStepData.index,
      dataViewId: defineStepData.dataViewId,
      timestampOverride: aboutStepData.timestampOverride,
      form: aboutStepForm,
      key: "aboutStep"
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null)))
  }, {
    'data-test-subj': 'edit-rule-schedule-tab',
    id: _types.RuleStep.scheduleRule,
    name: ruleI18n.SCHEDULE,
    disabled: rule === null || rule === void 0 ? void 0 : rule.immutable,
    content: /*#__PURE__*/_react.default.createElement("div", {
      style: {
        display: activeStep === _types.RuleStep.scheduleRule ? undefined : 'none'
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_step_panel.StepPanel, {
      loading: loading,
      title: ruleI18n.SCHEDULE
    }, scheduleStepData != null && /*#__PURE__*/_react.default.createElement(_step_schedule_rule.StepScheduleRule, {
      isLoading: isLoading,
      isUpdateView: true,
      form: scheduleStepForm,
      key: "scheduleStep"
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null)))
  }, {
    'data-test-subj': 'edit-rule-actions-tab',
    id: _types.RuleStep.ruleActions,
    name: ruleI18n.ACTIONS,
    content: /*#__PURE__*/_react.default.createElement("div", {
      style: {
        display: activeStep === _types.RuleStep.ruleActions ? undefined : 'none'
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_step_panel.StepPanel, {
      loading: loading
    }, actionsStepData != null && /*#__PURE__*/_react.default.createElement(_step_rule_actions.StepRuleActions, {
      ruleId: rule === null || rule === void 0 ? void 0 : rule.id,
      isLoading: isLoading,
      isUpdateView: true,
      actionMessageParams: actionMessageParams,
      summaryActionMessageParams: actionMessageParams,
      ruleType: rule === null || rule === void 0 ? void 0 : rule.type,
      form: actionsStepForm,
      key: "actionsStep"
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null)))
  }], [rule === null || rule === void 0 ? void 0 : rule.immutable, rule === null || rule === void 0 ? void 0 : rule.id, rule === null || rule === void 0 ? void 0 : rule.type, activeStep, loading, isSavedQueryLoading, isLoading, dataViewOptions, indicesConfig, threatIndicesConfig, savedQuery, defineStepForm, eqlOptionsSelected, setEqlOptionsSelected, indexPattern, isIndexPatternLoading, browserFields, isQueryBarValid, defineStepData, aboutStepData, aboutStepForm, scheduleStepData, scheduleStepForm, actionsStepData, actionMessageParams, actionsStepForm]);
  const {
    startTransaction
  } = (0, _use_start_transaction.useStartTransaction)();
  const onSubmit = (0, _react.useCallback)(async () => {
    const defineStepFormValid = await defineStepForm.validate();
    const aboutStepFormValid = await aboutStepForm.validate();
    const scheduleStepFormValid = await scheduleStepForm.validate();
    const actionsStepFormValid = await actionsStepForm.validate();
    if (defineStepFormValid && aboutStepFormValid && scheduleStepFormValid && actionsStepFormValid) {
      var _rule$name2;
      startTransaction({
        name: _user_actions.SINGLE_RULE_ACTIONS.SAVE
      });
      await updateRule({
        ...(0, _helpers2.formatRule)(defineStepData, aboutStepData, scheduleStepData, actionsStepData, rule === null || rule === void 0 ? void 0 : rule.exceptions_list),
        ...(ruleId ? {
          id: ruleId
        } : {}),
        ...(rule != null ? {
          max_signals: rule.max_signals
        } : {})
      });
      (0, _toasters.displaySuccessToast)(i18n.SUCCESSFULLY_SAVED_RULE((_rule$name2 = rule === null || rule === void 0 ? void 0 : rule.name) !== null && _rule$name2 !== void 0 ? _rule$name2 : ''), dispatchToaster);
      navigateToApp(_constants.APP_UI_ID, {
        deepLinkId: _types2.SecurityPageName.rules,
        path: (0, _redirect_to_detection_engine.getRuleDetailsUrl)(ruleId !== null && ruleId !== void 0 ? ruleId : '')
      });
    }
  }, [defineStepForm, aboutStepForm, scheduleStepForm, actionsStepForm, startTransaction, updateRule, defineStepData, aboutStepData, scheduleStepData, actionsStepData, rule, ruleId, dispatchToaster, navigateToApp]);
  const onTabClick = (0, _react.useCallback)(async tab => {
    const targetStep = tab.id;
    setActiveStep(targetStep);
  }, []);
  const renderTabs = () => {
    return tabs.map((tab, index) => /*#__PURE__*/_react.default.createElement(_eui.EuiTab, {
      key: index,
      onClick: () => onTabClick(tab),
      isSelected: tab.id === activeStep,
      disabled: tab.disabled,
      "data-test-subj": tab['data-test-subj']
    }, tab.name));
  };
  const goToDetailsRule = (0, _react.useCallback)(ev => {
    ev.preventDefault();
    navigateToApp(_constants.APP_UI_ID, {
      deepLinkId: _types2.SecurityPageName.rules,
      path: (0, _redirect_to_detection_engine.getRuleDetailsUrl)(ruleId !== null && ruleId !== void 0 ? ruleId : '')
    });
  }, [navigateToApp, ruleId]);
  if ((0, _helpers3.redirectToDetections)(isSignalIndexExists, isAuthenticated, hasEncryptionKey, needsListsConfiguration)) {
    navigateToApp(_constants.APP_UI_ID, {
      deepLinkId: _types2.SecurityPageName.alerts,
      path: (0, _redirect_to_detection_engine.getDetectionEngineUrl)()
    });
    return null;
  } else if (!(0, _privileges.hasUserCRUDPermission)(canUserCRUD)) {
    navigateToApp(_constants.APP_UI_ID, {
      deepLinkId: _types2.SecurityPageName.rules,
      path: (0, _redirect_to_detection_engine.getRuleDetailsUrl)(ruleId !== null && ruleId !== void 0 ? ruleId : '')
    });
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_page_wrapper.SecuritySolutionPageWrapper, null, /*#__PURE__*/_react.default.createElement(_eui.EuiResizableContainer, null, (EuiResizablePanel, EuiResizableButton, {
    togglePanel
  }) => {
    collapseFn.current = () => togglePanel === null || togglePanel === void 0 ? void 0 : togglePanel('preview', {
      direction: 'left'
    });
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(EuiResizablePanel, {
      initialSize: 70,
      minSize: '40%',
      mode: "main"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      direction: "row",
      justifyContent: "spaceAround"
    }, /*#__PURE__*/_react.default.createElement(_helpers3.MaxWidthEuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_.CustomHeaderPageMemo, {
      backOptions: backOptions,
      isLoading: isLoading,
      title: i18n.PAGE_TITLE,
      isRulePreviewVisible: isRulePreviewVisible,
      setIsRulePreviewVisible: setIsRulePreviewVisible,
      togglePanel: togglePanel
    }), invalidSteps.length > 0 && /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
      title: i18n.SORRY_ERRORS,
      color: "danger",
      iconType: "warning"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.detectionEngine.rule.editRule.errorMsgDescription",
      defaultMessage: "You have an invalid input in {countError, plural, one {this tab} other {these tabs}}: {tabHasError}",
      values: {
        countError: invalidSteps.length,
        tabHasError: invalidSteps.map(t => {
          if (t === _types.RuleStep.aboutRule) {
            return ruleI18n.ABOUT;
          } else if (t === _types.RuleStep.defineRule) {
            return ruleI18n.DEFINITION;
          } else if (t === _types.RuleStep.scheduleRule) {
            return ruleI18n.SCHEDULE;
          } else if (t === _types.RuleStep.ruleActions) {
            return ruleI18n.RULE_ACTIONS;
          }
          return t;
        }).join(', ')
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiTabs, null, renderTabs()), tabs.map(tab => tab.content), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      alignItems: "center",
      gutterSize: "s",
      justifyContent: "flexEnd",
      responsive: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      iconType: "cross",
      onClick: goToDetailsRule
    }, i18n.CANCEL)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      "data-test-subj": "ruleEditSubmitButton",
      fill: true,
      onClick: onSubmit,
      iconType: "save",
      isLoading: isLoading,
      isDisabled: loading
    }, i18n.SAVE_CHANGES)))))), /*#__PURE__*/_react.default.createElement(EuiResizableButton, null), /*#__PURE__*/_react.default.createElement(EuiResizablePanel, {
      id: 'preview',
      mode: "collapsible",
      initialSize: 30,
      minSize: '20%',
      onToggleCollapsed: () => setIsRulePreviewVisible(isVisible => !isVisible)
    }, /*#__PURE__*/_react.default.createElement(_rule_preview.RulePreview, {
      isDisabled: isPreviewDisabled,
      defineRuleData: defineStepData,
      aboutRuleData: aboutStepData,
      scheduleRuleData: scheduleStepData,
      exceptionsList: rule === null || rule === void 0 ? void 0 : rule.exceptions_list
    })));
  })), /*#__PURE__*/_react.default.createElement(_spy_routes.SpyRoute, {
    pageName: _types2.SecurityPageName.rules,
    state: {
      ruleName: rule === null || rule === void 0 ? void 0 : rule.name
    }
  }));
};
const EditRulePageWrapper = () => {
  const {
    detailName: ruleId
  } = (0, _reactRouterDom.useParams)();
  const {
    data: rule
  } = (0, _logic.useRule)(ruleId, true);
  return rule != null ? /*#__PURE__*/_react.default.createElement(EditRulePageComponent, {
    rule: rule
  }) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null);
};
const EditRulePage = /*#__PURE__*/(0, _react.memo)(EditRulePageWrapper);
exports.EditRulePage = EditRulePage;