"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.dashboardsLandingLinks = void 0;
var _i18n = require("@kbn/i18n");
var _constants = require("../../common/constants");
var _translations = require("../app/translations");
var _links = require("../kubernetes/links");
var _links2 = require("../cloud_security_posture/links");
var _links3 = require("../overview/links");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const dashboardsLandingLinks = {
  id: _constants.SecurityPageName.dashboards,
  title: _translations.DASHBOARDS,
  path: _constants.DASHBOARDS_PATH,
  globalNavPosition: 1,
  capabilities: [`${_constants.SERVER_APP_ID}.show`],
  globalSearchKeywords: [_i18n.i18n.translate('xpack.securitySolution.appLinks.dashboards', {
    defaultMessage: 'Dashboards'
  })],
  links: [_links3.overviewLinks, _links3.detectionResponseLinks, _links.links, _links2.dashboardLinks, _links2.vulnerabilityDashboardLink, _links3.entityAnalyticsLinks, _links3.ecsDataQualityDashboardLinks],
  skipUrlState: false
};
exports.dashboardsLandingLinks = dashboardsLandingLinks;