"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.testTrailingControlColumns = exports.testLeadingControlColumn = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SelectionHeaderCell = () => {
  return /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": "test-header-control-column-cell"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCheckbox, {
    id: "selection-toggle",
    "aria-label": "Select all rows",
    onChange: () => null
  }));
};
const SimpleHeaderCell = () => {
  return /*#__PURE__*/_react.default.createElement("div", {
    style: {
      fontSize: '12px',
      fontWeight: 600,
      lineHeight: 1.5,
      minWidth: 0,
      padding: '4px',
      width: '100%',
      display: 'flex',
      alignItems: 'center'
    },
    "data-test-subj": "test-header-action-cell"
  }, 'Additional Actions');
};
const SelectionRowCell = ({
  rowIndex
}) => {
  return /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": "test-body-control-column-cell"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCheckbox, {
    id: `${rowIndex}`,
    "aria-label": `Select row test`,
    checked: false,
    onChange: () => null
  }));
};
const TestTrailingColumn = () => {
  const [isPopoverOpen, setIsPopoverOpen] = (0, _react.useState)(false);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    isOpen: isPopoverOpen,
    anchorPosition: "upCenter",
    panelPaddingSize: "s",
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
      "aria-label": "show actions",
      iconType: "boxesHorizontal",
      color: "text",
      onClick: () => setIsPopoverOpen(!isPopoverOpen)
    }),
    "data-test-subj": "test-trailing-column-popover-button",
    closePopover: () => setIsPopoverOpen(false)
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopoverTitle, null, 'Actions'), /*#__PURE__*/_react.default.createElement("div", {
    style: {
      width: 150
    }
  }, /*#__PURE__*/_react.default.createElement("button", {
    type: "button",
    onClick: () => {}
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    component: "span",
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    "aria-label": "Pin selected items",
    iconType: "pin",
    color: "text"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, 'Pin'))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement("button", {
    type: "button",
    onClick: () => {}
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    component: "span",
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    "aria-label": "Delete selected items",
    iconType: "trash",
    color: "text"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, 'Delete')))));
};
const testTrailingControlColumns = [{
  id: 'actions',
  width: 96,
  headerCellRender: SimpleHeaderCell,
  rowCellRender: TestTrailingColumn
}];
exports.testTrailingControlColumns = testTrailingControlColumns;
const testLeadingControlColumn = {
  id: 'test-leading-control',
  headerCellRender: SelectionHeaderCell,
  rowCellRender: SelectionRowCell,
  width: 100
};
exports.testLeadingControlColumn = testLeadingControlColumn;