"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UpsellingService = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _rxjs = require("rxjs");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class UpsellingService {
  constructor() {
    (0, _defineProperty2.default)(this, "sections", void 0);
    (0, _defineProperty2.default)(this, "pages", void 0);
    (0, _defineProperty2.default)(this, "sectionsSubject$", void 0);
    (0, _defineProperty2.default)(this, "pagesSubject$", void 0);
    (0, _defineProperty2.default)(this, "sections$", void 0);
    (0, _defineProperty2.default)(this, "pages$", void 0);
    this.sections = new Map();
    this.sectionsSubject$ = new _rxjs.BehaviorSubject(new Map());
    this.sections$ = this.sectionsSubject$.asObservable();
    this.pages = new Map();
    this.pagesSubject$ = new _rxjs.BehaviorSubject(new Map());
    this.pages$ = this.pagesSubject$.asObservable();
  }
  registerSections(sections) {
    Object.entries(sections).forEach(([sectionId, component]) => {
      this.sections.set(sectionId, component);
    });
    this.sectionsSubject$.next(this.sections);
  }
  registerPages(pages) {
    Object.entries(pages).forEach(([pageId, component]) => {
      this.pages.set(pageId, component);
    });
    this.pagesSubject$.next(this.pages);
  }
  isPageUpsellable(id) {
    return this.pages.has(id);
  }
  getPageUpselling(id) {
    return this.pages.get(id);
  }
}
exports.UpsellingService = UpsellingService;