"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TelemetryClient = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _types = require("./types");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Client which aggregate all the available telemetry tracking functions
 * for the plugin
 */
class TelemetryClient {
  constructor(analytics) {
    (0, _defineProperty2.default)(this, "reportAlertsGroupingChanged", ({
      tableId,
      groupByField
    }) => {
      this.analytics.reportEvent(_types.TelemetryEventTypes.AlertsGroupingChanged, {
        tableId,
        groupByField
      });
    });
    (0, _defineProperty2.default)(this, "reportAlertsGroupingToggled", ({
      isOpen,
      tableId,
      groupNumber,
      groupName
    }) => {
      this.analytics.reportEvent(_types.TelemetryEventTypes.AlertsGroupingToggled, {
        isOpen,
        tableId,
        groupNumber,
        groupName
      });
    });
    (0, _defineProperty2.default)(this, "reportAlertsGroupingTakeAction", ({
      tableId,
      groupNumber,
      status,
      groupByField
    }) => {
      this.analytics.reportEvent(_types.TelemetryEventTypes.AlertsGroupingTakeAction, {
        tableId,
        groupNumber,
        status,
        groupByField
      });
    });
    (0, _defineProperty2.default)(this, "reportEntityDetailsClicked", ({
      entity
    }) => {
      this.analytics.reportEvent(_types.TelemetryEventTypes.EntityDetailsClicked, {
        entity
      });
    });
    (0, _defineProperty2.default)(this, "reportEntityAlertsClicked", ({
      entity
    }) => {
      this.analytics.reportEvent(_types.TelemetryEventTypes.EntityAlertsClicked, {
        entity
      });
    });
    (0, _defineProperty2.default)(this, "reportEntityRiskFiltered", ({
      entity,
      selectedSeverity
    }) => {
      this.analytics.reportEvent(_types.TelemetryEventTypes.EntityRiskFiltered, {
        entity,
        selectedSeverity
      });
    });
    (0, _defineProperty2.default)(this, "reportMLJobUpdate", params => {
      this.analytics.reportEvent(_types.TelemetryEventTypes.MLJobUpdate, params);
    });
    (0, _defineProperty2.default)(this, "reportCellActionClicked", params => {
      this.analytics.reportEvent(_types.TelemetryEventTypes.CellActionClicked, params);
    });
    (0, _defineProperty2.default)(this, "reportAnomaliesCountClicked", params => {
      this.analytics.reportEvent(_types.TelemetryEventTypes.AnomaliesCountClicked, params);
    });
    this.analytics = analytics;
  }
}
exports.TelemetryClient = TelemetryClient;