"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.hasCapabilities = void 0;
var _lodash = require("lodash");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const hasCapabilities = (capabilities, requiredCapabilities) => {
  if (!requiredCapabilities) {
    return true;
  }
  if (!(0, _lodash.isArray)(requiredCapabilities)) {
    return !!(0, _lodash.get)(capabilities, requiredCapabilities, false);
  } else {
    return requiredCapabilities.some(linkCapabilityKeyOr => {
      if ((0, _lodash.isArray)(linkCapabilityKeyOr)) {
        return linkCapabilityKeyOr.every(linkCapabilityKeyAnd => (0, _lodash.get)(capabilities, linkCapabilityKeyAnd, false));
      }
      return (0, _lodash.get)(capabilities, linkCapabilityKeyOr, false);
    });
  }
};
exports.hasCapabilities = hasCapabilities;