"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getTagsByName = exports.createTag = void 0;
var _constants = require("../../../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getTagsByName = ({
  http,
  tagName
}, abortSignal) => http.get(_constants.INTERNAL_TAGS_URL, {
  query: {
    name: tagName
  },
  signal: abortSignal
});
exports.getTagsByName = getTagsByName;
const createTag = ({
  http,
  tag
}, abortSignal) => http.put(_constants.INTERNAL_TAGS_URL, {
  body: JSON.stringify(tag),
  signal: abortSignal
});
exports.createTag = createTag;