"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ListItemComponent = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _helpers = require("./helpers");
var _entry_item = require("./entry_item");
var _entry_delete_button = require("./entry_delete_button");
var _and_badge = require("./and_badge");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const MyOverflowContainer = (0, _styledComponents.default)(_eui.EuiFlexItem)`
  overflow: hidden;
  width: 100%;
`;
const ListItemComponent = /*#__PURE__*/_react.default.memo(({
  listItem,
  listItemIndex,
  indexPattern,
  threatIndexPatterns,
  isOnlyItem,
  andLogicIncluded,
  onDeleteEntryItem,
  onChangeEntryItem
}) => {
  const handleEntryChange = (0, _react.useCallback)((entry, entryIndex) => {
    const updatedEntries = [...listItem.entries.slice(0, entryIndex), {
      ...entry
    }, ...listItem.entries.slice(entryIndex + 1)];
    const updatedEntryItem = {
      ...listItem,
      entries: updatedEntries
    };
    onChangeEntryItem(updatedEntryItem, listItemIndex);
  }, [onChangeEntryItem, listItem, listItemIndex]);
  const handleDeleteEntry = (0, _react.useCallback)(entryIndex => {
    const updatedEntryItem = (0, _helpers.getUpdatedEntriesOnDelete)(listItem, entryIndex);
    onDeleteEntryItem(updatedEntryItem, listItemIndex);
  }, [listItem, onDeleteEntryItem, listItemIndex]);
  const entries = (0, _react.useMemo)(() => indexPattern != null && listItem.entries.length > 0 ? (0, _helpers.getFormattedEntries)(indexPattern, threatIndexPatterns, listItem.entries) : [], [listItem.entries, indexPattern, threatIndexPatterns]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    "data-test-subj": "entriesContainer"
  }, andLogicIncluded && /*#__PURE__*/_react.default.createElement(_and_badge.AndBadgeComponent, {
    entriesLength: listItem.entries.length,
    entryItemIndex: listItemIndex
  }), /*#__PURE__*/_react.default.createElement(MyOverflowContainer, {
    grow: 6
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    direction: "column"
  }, entries.map((item, index) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    key: item.id,
    grow: 1
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "xs",
    alignItems: "center",
    direction: "row"
  }, /*#__PURE__*/_react.default.createElement(MyOverflowContainer, {
    grow: 1
  }, /*#__PURE__*/_react.default.createElement(_entry_item.EntryItem, {
    entry: item,
    threatIndexPatterns: threatIndexPatterns,
    indexPattern: indexPattern,
    showLabel: listItemIndex === 0 && index === 0,
    onChange: handleEntryChange
  })), /*#__PURE__*/_react.default.createElement(_entry_delete_button.EntryDeleteButtonComponent, {
    entries: listItem.entries,
    isOnlyItem: isOnlyItem,
    entryIndex: item.entryIndex,
    itemIndex: listItemIndex,
    onDelete: handleDeleteEntry
  }))))))));
});
exports.ListItemComponent = ListItemComponent;
ListItemComponent.displayName = 'ListItem';