"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ResponseActionsResults = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _endpoint_action_results = require("./endpoint_action_results");
var _kibana = require("../../lib/kibana");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ResponseActionsResults = /*#__PURE__*/_react.default.memo(({
  actions,
  ruleName,
  ecsData
}) => {
  const {
    services: {
      osquery
    }
  } = (0, _kibana.useKibana)();
  const {
    OsqueryResult
  } = osquery;
  const getAction = (0, _react.useCallback)(action => {
    if (isOsquery(action)) {
      const actionId = action.action_id;
      const startDate = action['@timestamp'];
      return /*#__PURE__*/_react.default.createElement(OsqueryResult, {
        key: actionId,
        actionId: actionId,
        startDate: startDate,
        ruleName: ruleName,
        ecsData: ecsData
      });
    }
    if (isEndpoint(action)) {
      return /*#__PURE__*/_react.default.createElement(_endpoint_action_results.EndpointResponseActionResults, {
        action: action,
        ruleName: ruleName,
        key: action.EndpointActions.action_id
      });
    }
    return null;
  }, [OsqueryResult, ecsData, ruleName]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, actions.map(action => {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s"
    }), getAction(action), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s"
    }));
  }));
});
exports.ResponseActionsResults = ResponseActionsResults;
ResponseActionsResults.displayName = 'ResponseActionsResults';
const isOsquery = item => {
  return item && 'input_type' in item && (item === null || item === void 0 ? void 0 : item.input_type) === 'osquery';
};
const isEndpoint = item => {
  return item && 'EndpointActions' in item && (item === null || item === void 0 ? void 0 : item.EndpointActions.input_type) === 'endpoint';
};