"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EndpointResponseActionResults = void 0;
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _react = _interopRequireWildcard(require("react"));
var _user_privileges = require("../user_privileges");
var _use_get_automated_action_list = require("../../../management/hooks/response_actions/use_get_automated_action_list");
var _action_log_expanded_tray = require("../../../management/components/endpoint_response_actions_list/components/action_log_expanded_tray");
var _translations = require("../event_details/translations");
var _response_actions_empty_prompt = require("./response_actions_empty_prompt");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const EndpointResponseActionResults = ({
  action,
  ruleName
}) => {
  const {
    agent
  } = action;
  const {
    action_id: actionId,
    expiration
  } = action.EndpointActions;
  const {
    endpointPrivileges: {
      canAccessEndpointActionsLogManagement
    }
  } = (0, _user_privileges.useUserPrivileges)();
  const [isLive, setIsLive] = (0, _react.useState)(true);
  const {
    data: expandedAction
  } = (0, _use_get_automated_action_list.useGetAutomatedActionResponseList)({
    actionId,
    expiration,
    agent
  }, {
    enabled: canAccessEndpointActionsLogManagement,
    action,
    isLive
  });
  (0, _react.useEffect)(() => {
    setIsLive(() => {
      var _expandedAction$error;
      if (!expandedAction) {
        return true;
      }
      return !((_expandedAction$error = expandedAction.errors) !== null && _expandedAction$error !== void 0 && _expandedAction$error.length) && expandedAction.status === 'pending';
    });
  }, [expandedAction]);
  const eventText = expandedAction ? getCommentText(expandedAction) : '';
  const hostName = (0, _react.useMemo)(
  // we want to get the first and only hostname
  () => expandedAction !== null && expandedAction !== void 0 && expandedAction.hosts ? Object.values(expandedAction.hosts)[0].name : '', [expandedAction === null || expandedAction === void 0 ? void 0 : expandedAction.hosts]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiComment, {
    username: ruleName,
    timestamp: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedRelative, {
      value: action['@timestamp']
    }),
    event: eventText,
    "data-test-subj": 'endpoint-results-comment'
  }, canAccessEndpointActionsLogManagement ? expandedAction ? /*#__PURE__*/_react.default.createElement(_action_log_expanded_tray.ActionsLogExpandedTray, {
    action: expandedAction,
    "data-test-subj": `response-results-${hostName}`
  }) : /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, null) : /*#__PURE__*/_react.default.createElement(_response_actions_empty_prompt.ResponseActionsEmptyPrompt, {
    type: "endpoint"
  }));
};
exports.EndpointResponseActionResults = EndpointResponseActionResults;
const getCommentText = action => {
  var _action$errors;
  if ((_action$errors = action.errors) !== null && _action$errors !== void 0 && _action$errors.length) {
    return _translations.ENDPOINT_COMMANDS.failed(action.command);
  }
  if (action.status === 'pending') {
    return _translations.ENDPOINT_COMMANDS.pending(action.command);
  }
  if (action.status === 'successful') {
    return _translations.ENDPOINT_COMMANDS.executed(action.command);
  }
  return _translations.ENDPOINT_COMMANDS.tried(action.command);
};