"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useBreadcrumbs = exports.getBreadcrumbsForRoute = void 0;
var _react = require("react");
var _fp = require("lodash/fp");
var _reactRedux = require("react-redux");
var _analytics = require("@kbn/analytics");
var _utils = require("../../../../explore/hosts/pages/details/utils");
var _utils2 = require("../../../../explore/network/pages/details/utils");
var _utils3 = require("../../../../detections/pages/detection_engine/rules/utils");
var _pages = require("../../../../exceptions/utils/pages.utils");
var _breadcrumbs = require("../../../../cloud_security_posture/breadcrumbs");
var _utils4 = require("../../../../explore/users/pages/details/utils");
var _breadcrumbs2 = require("../../../../kubernetes/pages/utils/breadcrumbs");
var _breadcrumbs3 = require("../../../../detections/pages/alert_details/utils/breadcrumbs");
var _utils5 = require("../../../../dashboards/pages/utils");
var _types = require("../../../../app/types");
var _timeline = require("../../../../timelines/store/timeline");
var _timeline2 = require("../../../../../common/types/timeline");
var _get_breadcrumbs_for_page = require("./get_breadcrumbs_for_page");
var _link_to = require("../../link_to");
var _telemetry = require("../../../lib/telemetry");
var _kibana = require("../../../lib/kibana");
var _use_route_spy = require("../../../utils/route/use_route_spy");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useBreadcrumbs = ({
  isEnabled
}) => {
  const dispatch = (0, _reactRedux.useDispatch)();
  const [routeProps] = (0, _use_route_spy.useRouteSpy)();
  const getSecuritySolutionUrl = (0, _link_to.useGetSecuritySolutionUrl)();
  const {
    chrome: {
      setBreadcrumbs
    },
    application: {
      navigateToUrl
    }
  } = (0, _kibana.useKibana)().services;
  (0, _react.useEffect)(() => {
    if (!isEnabled) {
      return;
    }
    const breadcrumbs = getBreadcrumbsForRoute(routeProps, getSecuritySolutionUrl);
    if (!breadcrumbs) {
      return;
    }
    setBreadcrumbs(breadcrumbs.map(breadcrumb => ({
      ...breadcrumb,
      ...(breadcrumb.href && !breadcrumb.onClick ? {
        onClick: ev => {
          var _breadcrumb$href$spli, _breadcrumb$href;
          ev.preventDefault();
          const trackedPath = (_breadcrumb$href$spli = (_breadcrumb$href = breadcrumb.href) === null || _breadcrumb$href === void 0 ? void 0 : _breadcrumb$href.split('?')[0]) !== null && _breadcrumb$href$spli !== void 0 ? _breadcrumb$href$spli : 'unknown';
          (0, _telemetry.track)(_analytics.METRIC_TYPE.CLICK, `${_telemetry.TELEMETRY_EVENT.BREADCRUMB}${trackedPath}`);
          dispatch(_timeline.timelineActions.showTimeline({
            id: _timeline2.TimelineId.active,
            show: false
          }));

          // eslint-disable-next-line @typescript-eslint/no-non-null-assertion
          navigateToUrl(breadcrumb.href);
        }
      } : {})
    })));
  }, [routeProps, isEnabled, dispatch, getSecuritySolutionUrl, setBreadcrumbs, navigateToUrl]);
};
exports.useBreadcrumbs = useBreadcrumbs;
const getBreadcrumbsForRoute = (spyState, getSecuritySolutionUrl) => {
  if (!(spyState !== null && spyState !== void 0 && spyState.pageName) ||
  // cases manages its own breadcrumbs, return null
  spyState.pageName === _types.SecurityPageName.case) {
    return null;
  }
  const leadingBreadcrumbs = (0, _get_breadcrumbs_for_page.getLeadingBreadcrumbsForSecurityPage)(spyState.pageName, getSecuritySolutionUrl);
  return emptyLastBreadcrumbUrl([...leadingBreadcrumbs, ...getTrailingBreadcrumbsForRoutes(spyState, getSecuritySolutionUrl)]);
};
exports.getBreadcrumbsForRoute = getBreadcrumbsForRoute;
const getTrailingBreadcrumbsForRoutes = (spyState, getSecuritySolutionUrl) => {
  switch (spyState.pageName) {
    case _types.SecurityPageName.hosts:
      return (0, _utils.getTrailingBreadcrumbs)(spyState, getSecuritySolutionUrl);
    case _types.SecurityPageName.network:
      return (0, _utils2.getTrailingBreadcrumbs)(spyState, getSecuritySolutionUrl);
    case _types.SecurityPageName.users:
      return (0, _utils4.getTrailingBreadcrumbs)(spyState, getSecuritySolutionUrl);
    case _types.SecurityPageName.rules:
    case _types.SecurityPageName.rulesAdd:
    case _types.SecurityPageName.rulesCreate:
      return (0, _utils3.getTrailingBreadcrumbs)(spyState, getSecuritySolutionUrl);
    case _types.SecurityPageName.exceptions:
      return (0, _pages.getTrailingBreadcrumbs)(spyState, getSecuritySolutionUrl);
    case _types.SecurityPageName.kubernetes:
      return (0, _breadcrumbs2.getTrailingBreadcrumbs)(spyState, getSecuritySolutionUrl);
    case _types.SecurityPageName.alerts:
      return (0, _breadcrumbs3.getTrailingBreadcrumbs)(spyState, getSecuritySolutionUrl);
    case _types.SecurityPageName.cloudSecurityPostureBenchmarks:
      return (0, _breadcrumbs.getTrailingBreadcrumbs)(spyState, getSecuritySolutionUrl);
    case _types.SecurityPageName.dashboards:
      return (0, _utils5.getTrailingBreadcrumbs)(spyState);
  }
  return [];
};
const emptyLastBreadcrumbUrl = breadcrumbs => {
  const leadingBreadCrumbs = breadcrumbs.slice(0, -1);
  const lastBreadcrumb = (0, _fp.last)(breadcrumbs);
  if (lastBreadcrumb) {
    return [...leadingBreadCrumbs, {
      ...lastBreadcrumb,
      href: ''
    }];
  }
  return breadcrumbs;
};