"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.GroupsFilterPopoverComponent = exports.GroupsFilterPopover = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var i18n = _interopRequireWildcard(require("./translations"));
var _toggle_selected_group = require("./toggle_selected_group");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Popover for selecting which SecurityJob groups to filter on. Component extracts unique groups and
 * their counts from the provided SecurityJobs. The 'siem' & 'security' groups are filtered out as all jobs will be
 * siem/security jobs
 *
 * @param securityJobs jobs to fetch groups from to display for filtering
 * @param onSelectedGroupsChanged change listener to be notified when group selection changes
 */
const GroupsFilterPopoverComponent = ({
  securityJobs,
  onSelectedGroupsChanged
}) => {
  const [isGroupPopoverOpen, setIsGroupPopoverOpen] = (0, _react.useState)(false);
  const [selectedGroups, setSelectedGroups] = (0, _react.useState)([]);
  const groups = securityJobs.map(j => j.groups).flat().filter(g => g !== 'siem' && g !== 'security');
  const uniqueGroups = Array.from(new Set(groups));
  (0, _react.useEffect)(() => {
    onSelectedGroupsChanged(selectedGroups);
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [selectedGroups.sort().join()]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    ownFocus: true,
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiFilterButton, {
      "data-test-subj": 'groups-filter-popover-button',
      iconType: "arrowDown",
      onClick: () => setIsGroupPopoverOpen(!isGroupPopoverOpen),
      isSelected: isGroupPopoverOpen,
      numFilters: uniqueGroups.length,
      hasActiveFilters: selectedGroups.length > 0,
      numActiveFilters: selectedGroups.length
    }, i18n.GROUPS),
    isOpen: isGroupPopoverOpen,
    closePopover: () => setIsGroupPopoverOpen(!isGroupPopoverOpen),
    panelPaddingSize: "none",
    repositionOnScroll: true
  }, uniqueGroups.map((group, index) => /*#__PURE__*/_react.default.createElement(_eui.EuiFilterSelectItem, {
    checked: selectedGroups.includes(group) ? 'on' : undefined,
    key: `${index}-${group}`,
    onClick: () => (0, _toggle_selected_group.toggleSelectedGroup)(group, selectedGroups, setSelectedGroups)
  }, `${group} (${groups.filter(g => g === group).length})`)), uniqueGroups.length === 0 && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "m",
    justifyContent: "spaceAround"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "minusInCircle"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xs"
  }), /*#__PURE__*/_react.default.createElement("p", null, i18n.NO_GROUPS_AVAILABLE))));
};
exports.GroupsFilterPopoverComponent = GroupsFilterPopoverComponent;
GroupsFilterPopoverComponent.displayName = 'GroupsFilterPopoverComponent';
const GroupsFilterPopover = /*#__PURE__*/_react.default.memo(GroupsFilterPopoverComponent);
exports.GroupsFilterPopover = GroupsFilterPopover;
GroupsFilterPopover.displayName = 'GroupsFilterPopover';