"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LinkIcon = exports.Link = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _styledComponents = _interopRequireWildcard(require("styled-components"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const Link = (0, _styledComponents.default)(({
  iconSide,
  children,
  ...rest
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiLink, rest, children))`
  ${({
  iconSide,
  theme
}) => (0, _styledComponents.css)`
    align-items: center;
    display: inline-flex;
    vertical-align: top;
    white-space: nowrap;

    ${iconSide === 'left' && (0, _styledComponents.css)`
      .euiIcon {
        margin-right: ${theme.eui.euiSizeXS};
      }
    `}

    ${iconSide === 'right' && (0, _styledComponents.css)`
      flex-direction: row-reverse;

      .euiIcon {
        margin-left: ${theme.eui.euiSizeXS};
      }
    `}
  `}
`;
exports.Link = Link;
Link.displayName = 'Link';
const LinkIcon = /*#__PURE__*/_react.default.memo(({
  ariaLabel,
  children,
  color,
  dataTestSubj,
  disabled,
  href,
  iconSide = 'left',
  iconSize = 's',
  iconType,
  onClick
}) => {
  const getChildrenString = (0, _react.useCallback)(theChild => {
    if (typeof theChild === 'object' && theChild != null && 'props' in theChild && theChild.props && theChild.props.children) {
      return getChildrenString(theChild.props.children);
    }
    return theChild != null && Object.keys(theChild).length > 0 ? theChild : '';
  }, []);
  const aria = (0, _react.useMemo)(() => {
    if (ariaLabel) {
      return ariaLabel;
    }
    return getChildrenString(children);
  }, [ariaLabel, children, getChildrenString]);
  return /*#__PURE__*/_react.default.createElement(Link, {
    className: "siemLinkIcon",
    color: color,
    "data-test-subj": dataTestSubj,
    disabled: disabled,
    href: href,
    iconSide: iconSide,
    onClick: onClick,
    "aria-label": aria
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    size: iconSize,
    type: iconType
  }), /*#__PURE__*/_react.default.createElement("span", {
    className: "siemLinkIcon__label"
  }, children));
});
exports.LinkIcon = LinkIcon;
LinkIcon.displayName = 'LinkIcon';