"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.HoverVisibilityContainer = void 0;
var _react = _interopRequireDefault(require("react"));
var _styledComponents = _interopRequireWildcard(require("styled-components"));
var _fp = require("lodash/fp");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const StyledDiv = _styledComponents.default.div`
  width: 100%;
  display: flex;
  flex-grow: 1;

  > * {
    max-width: 100%;
  }

  ${({
  targetClassNames
}) => (0, _styledComponents.css)`
      ${targetClassNames.map(cn => `.${cn}`).join(', ')} {
        pointer-events: none;
        opacity: 0;
        transition: opacity ${props => (0, _fp.getOr)(250, 'theme.eui.euiAnimSpeedNormal', props)} ease;
      }

      ${targetClassNames.map(cn => `&:hover .${cn}`).join(', ')} {
        pointer-events: auto;
        opacity: 1;
      }
    `}
`;
const HoverVisibilityContainer = /*#__PURE__*/_react.default.memo(({
  show = true,
  targetClassNames,
  children
}) => {
  if (!show) return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, children);
  return /*#__PURE__*/_react.default.createElement(StyledDiv, {
    "data-test-subj": "hoverVisibilityContainer",
    targetClassNames: targetClassNames
  }, children);
});
exports.HoverVisibilityContainer = HoverVisibilityContainer;
HoverVisibilityContainer.displayName = 'HoverVisibilityContainer';