"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CasesTourSteps = void 0;
var _react = _interopRequireWildcard(require("react"));
var _tour_config = require("./tour_config");
var _tour_step = require("./tour_step");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getSubmitButton = () => document.querySelector(`[tour-step="create-case-submit"]`);
const CasesTourSteps = () => {
  const [activeStep, setActiveStep] = (0, _react.useState)(_tour_config.AlertsCasesTourSteps.createCase);
  const scrollToSubmitButton = (0, _react.useCallback)(() => {
    var _getSubmitButton;
    (_getSubmitButton = getSubmitButton()) === null || _getSubmitButton === void 0 ? void 0 : _getSubmitButton.scrollIntoView();
  }, []);
  const onClick = (0, _react.useCallback)(() => {
    setActiveStep(_tour_config.AlertsCasesTourSteps.submitCase);
    scrollToSubmitButton();
    setTimeout(() => {
      var _getSubmitButton2;
      // something is resetting focus to close flyout button
      (_getSubmitButton2 = getSubmitButton()) === null || _getSubmitButton2 === void 0 ? void 0 : _getSubmitButton2.focus();
    }, 500);
  }, [scrollToSubmitButton]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, activeStep === _tour_config.AlertsCasesTourSteps.createCase && /*#__PURE__*/_react.default.createElement(_tour_step.GuidedOnboardingTourStep, {
    onClick: onClick,
    step: _tour_config.AlertsCasesTourSteps.createCase,
    tourId: _tour_config.SecurityStepId.alertsCases
  }), activeStep === _tour_config.AlertsCasesTourSteps.submitCase && /*#__PURE__*/_react.default.createElement(_tour_step.GuidedOnboardingTourStep, {
    step: _tour_config.AlertsCasesTourSteps.submitCase,
    tourId: _tour_config.SecurityStepId.alertsCases
  }));
};
exports.CasesTourSteps = CasesTourSteps;