"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useAlertBulkActions = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
const StatefulAlertBulkActions = /*#__PURE__*/(0, _react.lazy)(() => Promise.resolve().then(() => _interopRequireWildcard(require('../toolbar/bulk_actions/alert_bulk_actions'))));
const useAlertBulkActions = ({
  tableId,
  data,
  totalItems,
  indexNames,
  hasAlertsCrud,
  showCheckboxes,
  filterStatus,
  filterQuery,
  bulkActions,
  selectedCount
}) => {
  const showBulkActions = (0, _react.useMemo)(() => {
    var _ref, _bulkActions$customBu;
    if (!hasAlertsCrud) {
      return false;
    }
    if (selectedCount === 0 || !showCheckboxes) {
      return false;
    }
    if (typeof bulkActions === 'boolean') {
      return bulkActions;
    }
    return (_ref = (bulkActions === null || bulkActions === void 0 ? void 0 : (_bulkActions$customBu = bulkActions.customBulkActions) === null || _bulkActions$customBu === void 0 ? void 0 : _bulkActions$customBu.length) || (bulkActions === null || bulkActions === void 0 ? void 0 : bulkActions.alertStatusActions)) !== null && _ref !== void 0 ? _ref : true;
  }, [hasAlertsCrud, selectedCount, showCheckboxes, bulkActions]);
  const onAlertStatusActionSuccess = (0, _react.useMemo)(() => {
    if (bulkActions && bulkActions !== true) {
      return bulkActions.onAlertStatusActionSuccess;
    }
  }, [bulkActions]);
  const onAlertStatusActionFailure = (0, _react.useMemo)(() => {
    if (bulkActions && bulkActions !== true) {
      return bulkActions.onAlertStatusActionFailure;
    }
  }, [bulkActions]);
  const showAlertStatusActions = (0, _react.useMemo)(() => {
    var _ref2;
    if (!hasAlertsCrud) {
      return false;
    }
    if (typeof bulkActions === 'boolean') {
      return bulkActions;
    }
    return (_ref2 = bulkActions && bulkActions.alertStatusActions) !== null && _ref2 !== void 0 ? _ref2 : true;
  }, [bulkActions, hasAlertsCrud]);
  const additionalBulkActions = (0, _react.useMemo)(() => {
    if (bulkActions && bulkActions !== true && bulkActions.customBulkActions !== undefined) {
      return bulkActions.customBulkActions.map(action => {
        return {
          ...action,
          onClick: eventIds => {
            const items = data.filter(item => {
              return eventIds.find(event => item._id === event);
            });
            action.onClick(items);
          }
        };
      });
    }
  }, [bulkActions, data]);
  const alertBulkActions = (0, _react.useMemo)(() => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, showBulkActions && /*#__PURE__*/_react.default.createElement(_react.Suspense, {
    fallback: /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, null)
  }, /*#__PURE__*/_react.default.createElement(StatefulAlertBulkActions, {
    showAlertStatusActions: showAlertStatusActions,
    "data-test-subj": "bulk-actions",
    id: tableId,
    totalItems: totalItems,
    filterStatus: filterStatus,
    query: filterQuery,
    indexName: indexNames.join(),
    onActionSuccess: onAlertStatusActionSuccess,
    onActionFailure: onAlertStatusActionFailure,
    customBulkActions: additionalBulkActions
  }))), [additionalBulkActions, filterQuery, filterStatus, indexNames, onAlertStatusActionFailure, onAlertStatusActionSuccess, showAlertStatusActions, showBulkActions, tableId, totalItems]);
  return alertBulkActions;
};
exports.useAlertBulkActions = useAlertBulkActions;