"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SummaryViewSelector = void 0;
var _eui = require("@elastic/eui");
var _public = require("@kbn/kibana-utils-plugin/public");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _constants = require("../../../../../common/constants");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const storage = new _public.Storage(localStorage);
const ContainerEuiSelectable = _styledComponents.default.div`
  width: 300px;
  .euiSelectableListItem__text {
    white-space: pre-wrap !important;
    line-height: normal;
  }
`;
const gridView = _i18n.i18n.translate('xpack.securitySolution.selector.summaryView.gridView.label', {
  defaultMessage: 'Grid view'
});
const eventRenderedView = _i18n.i18n.translate('xpack.securitySolution.selector.summaryView.eventRendererView.label', {
  defaultMessage: 'Event rendered view'
});
const SummaryViewSelectorComponent = ({
  viewSelected,
  onViewChange
}) => {
  const [isPopoverOpen, setIsPopoverOpen] = (0, _react.useState)(false);
  const onButtonClick = (0, _react.useCallback)(() => setIsPopoverOpen(currentVal => !currentVal), []);
  const closePopover = (0, _react.useCallback)(() => setIsPopoverOpen(false), []);
  const onChangeSelectable = (0, _react.useCallback)(opts => {
    var _selected$0$key, _selected$;
    const selected = opts.filter(i => i.checked === 'on');
    storage.set(_constants.ALERTS_TABLE_VIEW_SELECTION_KEY, (_selected$0$key = (_selected$ = selected[0]) === null || _selected$ === void 0 ? void 0 : _selected$.key) !== null && _selected$0$key !== void 0 ? _selected$0$key : 'gridView');
    if (selected.length > 0) {
      var _selected$0$key2, _selected$2;
      onViewChange((_selected$0$key2 = (_selected$2 = selected[0]) === null || _selected$2 === void 0 ? void 0 : _selected$2.key) !== null && _selected$0$key2 !== void 0 ? _selected$0$key2 : 'gridView');
    }
    setIsPopoverOpen(false);
  }, [onViewChange]);
  const button = (0, _react.useMemo)(() => /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    iconType: "arrowDown",
    iconSide: "right",
    iconSize: "s",
    onClick: onButtonClick,
    size: "xs",
    flush: "both",
    style: {
      fontWeight: 'normal'
    }
  }, viewSelected === 'gridView' ? gridView : eventRenderedView), [onButtonClick, viewSelected]);
  const options = (0, _react.useMemo)(() => [{
    label: gridView,
    key: 'gridView',
    checked: viewSelected === 'gridView' ? 'on' : undefined,
    meta: [{
      text: _i18n.i18n.translate('xpack.securitySolution.selector.summaryView.options.default.description', {
        defaultMessage: 'View as tabular data with the ability to group and sort by specific fields'
      })
    }]
  }, {
    label: eventRenderedView,
    key: 'eventRenderedView',
    checked: viewSelected === 'eventRenderedView' ? 'on' : undefined,
    meta: [{
      text: _i18n.i18n.translate('xpack.securitySolution.selector.summaryView.options.summaryView.description', {
        defaultMessage: 'View a rendering of the event flow for each alert'
      })
    }]
  }], [viewSelected]);
  const renderOption = (0, _react.useCallback)(option => {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "xxs"
    }, /*#__PURE__*/_react.default.createElement("h6", null, option.label)), /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
      color: "subdued"
    }, /*#__PURE__*/_react.default.createElement("small", null, option.meta[0].text)));
  }, []);
  const listProps = (0, _react.useMemo)(() => ({
    rowHeight: 80,
    showIcons: true
  }), []);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    panelPaddingSize: "none",
    button: button,
    isOpen: isPopoverOpen,
    closePopover: closePopover
  }, /*#__PURE__*/_react.default.createElement(ContainerEuiSelectable, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSelectable, {
    options: options,
    onChange: onChangeSelectable,
    renderOption: renderOption,
    searchable: false,
    height: 160,
    listProps: listProps,
    singleSelection: true
  }, list => list)));
};
const SummaryViewSelector = /*#__PURE__*/_react.default.memo(SummaryViewSelectorComponent);
exports.SummaryViewSelector = SummaryViewSelector;