"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useActionCellDataProvider = exports.getDataProviderAnd = exports.getDataProvider = void 0;
var _securitysolutionTGrid = require("@kbn/securitysolution-t-grid");
var _fp = require("lodash/fp");
var _react = require("react");
var _constants = require("../../../../timelines/components/timeline/body/renderers/constants");
var _bytes = require("../../../../timelines/components/timeline/body/renderers/bytes");
var _duration = require("../../../../timelines/components/duration");
var _helpers = require("../../../../timelines/components/timeline/data_providers/helpers");
var _helpers2 = require("../../../../explore/network/components/port/helpers");
var _constants2 = require("../../../../../common/cti/constants");
var _types = require("../../../../../common/types");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/* eslint-disable complexity */

const getDataProvider = (field, id, value, operator = _types.IS_OPERATOR) => ({
  and: [],
  enabled: true,
  id: (0, _securitysolutionTGrid.escapeDataProviderId)(id),
  name: field,
  excluded: false,
  kqlQuery: '',
  queryMatch: {
    field,
    value,
    operator,
    displayValue: (0, _helpers.getDisplayValue)(value)
  }
});
exports.getDataProvider = getDataProvider;
const getDataProviderAnd = (field, id, value, operator = _types.IS_OPERATOR) => {
  const {
    and,
    ...dataProvider
  } = getDataProvider(field, id, value, operator);
  return dataProvider;
};
exports.getDataProviderAnd = getDataProviderAnd;
const useActionCellDataProvider = ({
  contextId,
  eventId,
  field,
  fieldFormat,
  fieldFromBrowserField,
  fieldType,
  isObjectArray,
  linkValue,
  values
}) => {
  const cellData = (0, _react.useMemo)(() => {
    if (values === null || values === undefined) return null;
    const arrayValues = Array.isArray(values) ? values : [values];

    // For fields with multiple values we need add an extra filter that makes sure
    // that only fields that match ALL the values are queried later on.
    let filters = [];
    if (arrayValues.length > 1) {
      filters = [{
        meta: {},
        query: {
          bool: {
            must: arrayValues.map(value => ({
              term: {
                [field]: value
              }
            }))
          }
        }
      }];
    }
    return arrayValues.reduce((memo, value, index) => {
      let id = '';
      let valueAsString = (0, _fp.isString)(value) ? value : `${values}`;
      const appendedUniqueId = `${contextId}-${eventId}-${field}-${index}-${value}`;
      if (fieldFromBrowserField == null) {
        memo.values.push(valueAsString);
        return memo;
      }
      if (isObjectArray || fieldType === _constants.GEO_FIELD_TYPE || [_constants.MESSAGE_FIELD_NAME].includes(field)) {
        memo.values.push(valueAsString);
        return memo;
      } else if (fieldType === _constants.IP_FIELD_TYPE) {
        id = `formatted-ip-data-provider-${contextId}-${field}-${value}-${eventId}`;
        if ((0, _fp.isString)(value) && !(0, _fp.isEmpty)(value)) {
          let addresses = value;
          try {
            addresses = JSON.parse(value);
          } catch (_) {
            // Default to keeping the existing string value
          }
          if ((0, _fp.isArray)(addresses)) {
            valueAsString = addresses.join(',');
            addresses.forEach(ip => memo.dataProviders.push(getDataProvider(field, id, ip)));
          }
          memo.dataProviders.push(getDataProvider(field, id, addresses));
          memo.values.push(valueAsString);
          return memo;
        }
      } else if (_helpers2.PORT_NAMES.some(portName => field === portName)) {
        id = `port-default-draggable-${appendedUniqueId}`;
      } else if (field === _duration.EVENT_DURATION_FIELD_NAME) {
        id = `duration-default-draggable-${appendedUniqueId}`;
      } else if (field === _constants.HOST_NAME_FIELD_NAME) {
        id = `event-details-value-default-draggable-${appendedUniqueId}`;
      } else if (fieldFormat === _bytes.BYTES_FORMAT) {
        id = `bytes-default-draggable-${appendedUniqueId}`;
      } else if (field === _constants.SIGNAL_RULE_NAME_FIELD_NAME) {
        id = `event-details-value-default-draggable-${appendedUniqueId}-${linkValue}`;
      } else if (field === _constants.EVENT_MODULE_FIELD_NAME) {
        id = `event-details-value-default-draggable-${appendedUniqueId}-${value}`;
      } else if (field === _constants.SIGNAL_STATUS_FIELD_NAME) {
        id = `alert-details-value-default-draggable-${appendedUniqueId}`;
      } else if (field === _constants.AGENT_STATUS_FIELD_NAME) {
        const valueToUse = typeof value === 'string' ? value : '';
        id = `event-details-value-default-draggable-${appendedUniqueId}`;
        valueAsString = valueToUse;
      } else if ([_constants.RULE_REFERENCE_FIELD_NAME, _constants.REFERENCE_URL_FIELD_NAME, _constants.EVENT_URL_FIELD_NAME, _constants2.INDICATOR_REFERENCE].includes(field)) {
        id = `event-details-value-default-draggable-${appendedUniqueId}-${value}`;
      } else {
        id = `event-details-value-default-draggable-${appendedUniqueId}`;
      }
      memo.values.push(valueAsString);
      memo.dataProviders.push(getDataProvider(field, id, value));
      return memo;
    }, {
      values: [],
      dataProviders: [],
      filters
    });
  }, [contextId, eventId, field, fieldFormat, fieldFromBrowserField, fieldType, isObjectArray, linkValue, values]);
  return cellData;
};
exports.useActionCellDataProvider = useActionCellDataProvider;