"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useResponseActionsView = void 0;
var _react = _interopRequireDefault(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _eui = require("@elastic/eui");
var _response_actions_results = require("../response_actions/response_actions_results");
var _expand_dotted = require("../../../../common/utils/expand_dotted");
var _use_get_automated_action_list = require("../../../management/hooks/response_actions/use_get_automated_action_list");
var _event_details = require("./event_details");
var i18n = _interopRequireWildcard(require("./translations"));
var _use_experimental_features = require("../../hooks/use_experimental_features");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const TabContentWrapper = _styledComponents.default.div`
  height: 100%;
  position: relative;
`;
const useResponseActionsView = ({
  rawEventData,
  ecsData
}) => {
  var _expandedEventFieldsO, _expandedEventFieldsO2, _expandedEventFieldsO3, _expandedEventFieldsO4, _rawEventData$_id, _expandedEventFieldsO5, _expandedEventFieldsO6, _expandedEventFieldsO7, _expandedEventFieldsO8, _automatedList$items$, _automatedList$items;
  const responseActionsEnabled = (0, _use_experimental_features.useIsExperimentalFeatureEnabled)('endpointResponseActionsEnabled');
  const expandedEventFieldsObject = rawEventData ? (0, _expand_dotted.expandDottedObject)(rawEventData.fields) : undefined;
  const responseActions = expandedEventFieldsObject === null || expandedEventFieldsObject === void 0 ? void 0 : (_expandedEventFieldsO = expandedEventFieldsObject.kibana) === null || _expandedEventFieldsO === void 0 ? void 0 : (_expandedEventFieldsO2 = _expandedEventFieldsO.alert) === null || _expandedEventFieldsO2 === void 0 ? void 0 : (_expandedEventFieldsO3 = _expandedEventFieldsO2.rule) === null || _expandedEventFieldsO3 === void 0 ? void 0 : (_expandedEventFieldsO4 = _expandedEventFieldsO3.parameters) === null || _expandedEventFieldsO4 === void 0 ? void 0 : _expandedEventFieldsO4[0].response_actions;
  const shouldEarlyReturn = !rawEventData || !responseActionsEnabled || !(responseActions !== null && responseActions !== void 0 && responseActions.length);
  const alertId = (_rawEventData$_id = rawEventData === null || rawEventData === void 0 ? void 0 : rawEventData._id) !== null && _rawEventData$_id !== void 0 ? _rawEventData$_id : '';
  const {
    data: automatedList,
    isFetched
  } = (0, _use_get_automated_action_list.useGetAutomatedActionList)({
    alertIds: [alertId]
  }, {
    enabled: !shouldEarlyReturn
  });
  if (shouldEarlyReturn) {
    return;
  }
  const ruleName = expandedEventFieldsObject === null || expandedEventFieldsObject === void 0 ? void 0 : (_expandedEventFieldsO5 = expandedEventFieldsObject.kibana) === null || _expandedEventFieldsO5 === void 0 ? void 0 : (_expandedEventFieldsO6 = _expandedEventFieldsO5.alert) === null || _expandedEventFieldsO6 === void 0 ? void 0 : (_expandedEventFieldsO7 = _expandedEventFieldsO6.rule) === null || _expandedEventFieldsO7 === void 0 ? void 0 : (_expandedEventFieldsO8 = _expandedEventFieldsO7.name) === null || _expandedEventFieldsO8 === void 0 ? void 0 : _expandedEventFieldsO8[0];
  const totalItemCount = (_automatedList$items$ = automatedList === null || automatedList === void 0 ? void 0 : (_automatedList$items = automatedList.items) === null || _automatedList$items === void 0 ? void 0 : _automatedList$items.length) !== null && _automatedList$items$ !== void 0 ? _automatedList$items$ : 0;
  const content = /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(TabContentWrapper, {
    "data-test-subj": "responseActionsViewWrapper"
  }, isFetched && totalItemCount && automatedList !== null && automatedList !== void 0 && automatedList.items.length ? /*#__PURE__*/_react.default.createElement(_response_actions_results.ResponseActionsResults, {
    actions: automatedList.items,
    ruleName: ruleName,
    ecsData: ecsData
  }) : null));
  return {
    id: _event_details.EventsViewType.responseActionsView,
    'data-test-subj': 'responseActionsViewTab',
    name: i18n.RESPONSE_ACTIONS_VIEW,
    append: /*#__PURE__*/_react.default.createElement(_eui.EuiNotificationBadge, {
      "data-test-subj": "response-actions-notification"
    }, totalItemCount),
    content
  };
};
exports.useResponseActionsView = useResponseActionsView;