"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EnrichmentRangePicker = void 0;
var _moment = _interopRequireDefault(require("moment"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var i18n = _interopRequireWildcard(require("./translations"));
var _constants = require("../../../../../common/cti/constants");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const EnrichmentRangePicker = ({
  range,
  setRange,
  loading
}) => {
  const [startDate, setStartDate] = (0, _react.useState)(range.from === _constants.DEFAULT_EVENT_ENRICHMENT_FROM ? (0, _moment.default)().subtract(30, 'd') : (0, _moment.default)(range.from));
  const [endDate, setEndDate] = (0, _react.useState)(range.to === _constants.DEFAULT_EVENT_ENRICHMENT_TO ? (0, _moment.default)() : (0, _moment.default)(range.to));
  const onButtonClick = (0, _react.useCallback)(() => {
    if (startDate && endDate && startDate.isBefore(endDate)) {
      setRange({
        from: startDate.toISOString(),
        to: endDate.toISOString()
      });
    }
  }, [endDate, setRange, startDate]);
  const isValid = (0, _react.useMemo)(() => startDate === null || startDate === void 0 ? void 0 : startDate.isBefore(endDate), [startDate, endDate]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiDatePickerRange, {
    "data-test-subj": "enrichment-query-range-picker",
    startDateControl: /*#__PURE__*/_react.default.createElement(_eui.EuiDatePicker, {
      className: "start-picker",
      selected: startDate,
      onChange: setStartDate,
      startDate: startDate,
      endDate: endDate,
      isInvalid: !isValid,
      "aria-label": i18n.ENRICHMENT_LOOKBACK_START_DATE,
      showTimeSelect: true
    }),
    endDateControl: /*#__PURE__*/_react.default.createElement(_eui.EuiDatePicker, {
      className: "end-picker",
      selected: endDate,
      onChange: setEndDate,
      startDate: startDate,
      endDate: endDate,
      isInvalid: !isValid,
      "aria-label": i18n.ENRICHMENT_LOOKBACK_END_DATE,
      showTimeSelect: true
    })
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    iconType: 'refresh',
    onClick: onButtonClick,
    isLoading: loading,
    "data-test-subj": 'enrichment-button',
    isDisabled: !isValid
  }, i18n.REFRESH)));
};
exports.EnrichmentRangePicker = EnrichmentRangePicker;