"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ConditionsTable = void 0;
var _react = _interopRequireDefault(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _eui = require("@elastic/eui");
var _and_or_badge = require("../and_or_badge");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AndOrBadgeContainer = (0, _styledComponents.default)(_eui.EuiFlexItem)`
  padding-top: ${({
  theme
}) => theme.eui.euiSizeXL};
  padding-bottom: ${({
  theme
}) => theme.eui.euiSizeS};
`;
const ConditionsTable = ({
  badge,
  ...props
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    gutterSize: "none"
  }, props.items.length > 1 && /*#__PURE__*/_react.default.createElement(_eui.EuiHideFor, {
    sizes: ['xs', 's']
  }, /*#__PURE__*/_react.default.createElement(AndOrBadgeContainer, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_and_or_badge.AndOrBadge, {
    type: badge,
    includeAntennas: true
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 1
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiBasicTable, props)));
};
exports.ConditionsTable = ConditionsTable;
ConditionsTable.displayName = 'ConditionsTable';